/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checks.arrays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kenya.eclipse.ast.AdvancedPositionFinder;
import kenya.eclipse.ast.NodeToString;
import kenya.eclipse.ast.NodeTools;
import kenya.eclipse.ast.OccurrencesFinder;
import kenya.eclipse.ast.SimpleASTProvider;
import kenya.eclipse.multieditor.kenya.util.SourceCodeLocationComparator;
import kenya.eclipse.style.checkerimpl.AbstractStyleChecker;
import kenya.eclipse.style.checks.arrays.ArrayDeclarationFinder;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import mediator.ICheckedCode;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.AArrayFieldAccess;
import minijava.node.AArrayInit;
import minijava.node.AArrayInitList;
import minijava.node.AAssignment;
import minijava.node.ACommaArrayInit;
import minijava.node.AScalarFieldAccess;
import minijava.node.AScalarInitList;
import minijava.node.AStaticArrayInitialiser;
import minijava.node.Node;
import minijava.node.PArrayInitialiser;
import minijava.node.PFieldAccess;
import minijava.node.PInitList;
import minijava.node.Start;
import minijava.node.TIdentifier;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;

public class IndexOutOfBoundsChecker
extends AbstractStyleChecker {
    private static final Pattern NAME = Pattern.compile("\\s*[\\w\\.\\d]+");
    private static final Pattern ARRAY_ACCESS = Pattern.compile("\\[\\s*(\\d+)?(" + NAME.pattern() + ")?\\s*\\]");
    private static final Pattern SCALAR_DECLARATION = Pattern.compile("\\s*(\\{.*\\})\\s*", 32);
    private static final Pattern DYN_DECLARATION = Pattern.compile("new\\s+[\\w\\d]+\\s*(" + ARRAY_ACCESS.pattern() + "*)+");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void configure(Map customAttributes) {
    }

    public void performCheck(ICheckedCode code, IFile file) {
        IDocument doc = IndexOutOfBoundsChecker.getDocument(file);
        Start ast = SimpleASTProvider.getAST(code);
        ArrayList arrayDeclarations = this.findAllArrayDeclarations(code);
        Iterator it = arrayDeclarations.iterator();
        while (it.hasNext()) {
            ISourceCodeLocation loc;
            AArrayDecInnerDeclaration dec = (AArrayDecInnerDeclaration)it.next();
            System.out.println("\n----------");
            System.out.println("array declaration: " + dec);
            OccurrencesFinder f = new OccurrencesFinder();
            String m = f.initialize(ast, code, doc, AdvancedPositionFinder.getFullLocation((Node)dec.getIdentifier(), doc));
            if (m != null) continue;
            List ids = f.perform();
            ArrayList<Object> locs = new ArrayList<Object>();
            HashMap<Object, String[]> locToLen = new HashMap<Object, String[]>();
            ArrayList<PFieldAccess> usages = new ArrayList<PFieldAccess>();
            Iterator iter = ids.iterator();
            while (iter.hasNext()) {
                AArrayDecInnerDeclaration decl;
                PFieldAccess fieldaccess;
                TIdentifier id = (TIdentifier)iter.next();
                System.out.println(id.parent().parent().parent());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("minijava.node.PAssignment");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                AAssignment assign = (AAssignment)NodeTools.getParent((Node)id, clazz);
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("minijava.node.PFieldAccess");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((fieldaccess = (PFieldAccess)NodeTools.getParent((Node)id, clazz2)) instanceof AArrayFieldAccess) {
                    usages.add(fieldaccess);
                    continue;
                }
                if (assign != null) {
                    if (assign.getFieldAccess() != fieldaccess || !(fieldaccess instanceof AScalarFieldAccess)) continue;
                    loc = AdvancedPositionFinder.getFullLocation((Node)assign, doc);
                    locs.add(loc);
                    locToLen.put(loc, this.getDeclaredLength((Node)assign.getExpression()));
                    continue;
                }
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("minijava.node.AArrayDecInnerDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((decl = (AArrayDecInnerDeclaration)NodeTools.getParent((Node)id, clazz3)) != null) {
                    PArrayInitialiser initialiser = decl.getArrayInitialiser();
                    if (initialiser == null) continue;
                    SourceCodeLocation loc2 = new SourceCodeLocation(1, 1, 0);
                    locs.add(loc2);
                    locToLen.put(loc2, this.getDeclaredLength((Node)initialiser));
                    continue;
                }
                System.out.println("uncovered case");
            }
            ISourceCodeLocation[] locations = locs.toArray(new ISourceCodeLocation[locs.size()]);
            Arrays.sort(locations, SourceCodeLocationComparator.getInstance());
            if (locations.length == 0) continue;
            System.out.println("accesses:");
            Iterator it1 = usages.iterator();
            while (it1.hasNext()) {
                AArrayFieldAccess acc = (AArrayFieldAccess)it1.next();
                ISourceCodeLocation currentLoc = AdvancedPositionFinder.getFullLocation((Node)acc, doc);
                loc = this.getJustBefore(locations, currentLoc);
                String[] length = (String[])locToLen.get(loc);
                String[] g = this.getAccessLength((Node)acc);
                int i = 0;
                while (i < g.length) {
                    System.out.print(String.valueOf(g[i]) + "/");
                    if (i < length.length) {
                        System.out.print(String.valueOf(length[i]) + "  ");
                    }
                    ++i;
                }
            }
        }
    }

    private ISourceCodeLocation getJustBefore(ISourceCodeLocation[] locs, ISourceCodeLocation l) {
        ISourceCodeLocation closest = null;
        SourceCodeLocationComparator c = SourceCodeLocationComparator.getInstance();
        int i = 0;
        while (i < locs.length) {
            if (c.compare(locs[i], l) > 0) break;
            closest = locs[i];
            ++i;
        }
        return closest;
    }

    private String[] getAccessLength(Node n) {
        String txt = NodeToString.toString(n);
        Pattern p = Pattern.compile(String.valueOf(NAME.pattern()) + "(" + ARRAY_ACCESS.pattern() + ")+");
        Matcher m = p.matcher(txt);
        if (m.matches()) {
            txt = txt.substring(m.start(1));
            return this.getArrayAccessLength(txt);
        }
        return new String[0];
    }

    private String[] getDeclaredLength(Node n) {
        if (n instanceof AStaticArrayInitialiser) {
            AStaticArrayInitialiser in = (AStaticArrayInitialiser)n;
            AArrayInit init = (AArrayInit)in.getArrayInit();
            this.getNumberOfDimensions(init);
            init.getInitList();
            this.getLength((AArrayInitList)init.getInitList());
        }
        String txt = NodeToString.toString(n);
        return this.getDeclaredLength(txt);
    }

    private int getNumberOfDimensions(AArrayInit init) {
        PInitList list = init.getInitList();
        if (list instanceof AArrayInitList) {
            int s = 1;
            AArrayInitList l = (AArrayInitList)list;
            AArrayInit in = (AArrayInit)l.getArrayInit();
            s += this.getNumberOfDimensions(in);
            LinkedList abc = l.getCommaArrayInit();
            if (l != null) {
                Iterator it = abc.iterator();
                while (it.hasNext()) {
                    ACommaArrayInit element = (ACommaArrayInit)it.next();
                    in = (AArrayInit)element.getArrayInit();
                    s += this.getNumberOfDimensions(in);
                }
            }
            return s;
        }
        if (list instanceof AScalarInitList) {
            return 1;
        }
        return 0;
    }

    private int getLength(AArrayInitList list) {
        return list.getCommaArrayInit() != null ? list.getCommaArrayInit().size() + 1 : 1;
    }

    private String[] getDeclaredLength(String txt) {
        Matcher m = DYN_DECLARATION.matcher(txt);
        if (m.matches()) {
            return this.getArrayAccessLength(m.group(1));
        }
        return new String[0];
    }

    private String[] getArrayAccessLength(String txt) {
        Matcher m = ARRAY_ACCESS.matcher(txt);
        ArrayList<String> list = new ArrayList<String>();
        while (m.find()) {
            if (m.group(1) != null) {
                list.add(m.group(1));
                continue;
            }
            list.add(m.group(2));
        }
        return list.toArray(new String[list.size()]);
    }

    private ArrayList findAllArrayDeclarations(ICheckedCode code) {
        return new ArrayDeclarationFinder().perform(SimpleASTProvider.getAST(code));
    }
}

