/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checks.bool;

import kenya.eclipse.ast.NodeTools;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AAndBoolTerm;
import minijava.node.ABoolexpExpression;
import minijava.node.ABoolliteralFactor;
import minijava.node.AEqEquality;
import minijava.node.AEqualityBoolTerm;
import minijava.node.AExpressionFactor;
import minijava.node.AFactorPostfixExp;
import minijava.node.AFalseBooleanliteral;
import minijava.node.AGtRelational;
import minijava.node.AGteqRelational;
import minijava.node.ALtRelational;
import minijava.node.ALteqRelational;
import minijava.node.AMathRelational;
import minijava.node.ANegateUnaryExp;
import minijava.node.ANeqEquality;
import minijava.node.AOrBoolExpression;
import minijava.node.APostfixExpUnaryExp;
import minijava.node.ARelationalEquality;
import minijava.node.ATermBoolExpression;
import minijava.node.ATermMathExpression;
import minijava.node.ATrueBooleanliteral;
import minijava.node.AUnaryTerm;
import minijava.node.AXorBoolExpression;
import minijava.node.Node;
import minijava.node.PBoolExpression;
import minijava.node.PBoolTerm;
import minijava.node.PBooleanliteral;
import minijava.node.PEquality;
import minijava.node.PFactor;
import minijava.node.PMathExpression;
import minijava.node.PPostfixExp;
import minijava.node.PRelational;
import minijava.node.PTerm;
import minijava.node.PUnaryExp;
import minijava.node.Switch;
import minijava.node.TEqual;
import minijava.node.TFalse;
import minijava.node.TGreater;
import minijava.node.TGreaterequal;
import minijava.node.TIdentifier;
import minijava.node.TLParenthese;
import minijava.node.TLess;
import minijava.node.TLessequal;
import minijava.node.TNot;
import minijava.node.TNotequal;
import minijava.node.TRParenthese;
import minijava.node.TTrue;

public class BoolNodeTools
extends NodeTools {
    protected BoolNodeTools() {
    }

    public static Node getLargestBoolNode(Node n) {
        LargestSearch g = new LargestSearch(n);
        Node nana = g.getLargestBoolNode();
        return nana;
    }

    public static boolean isAnd(Node n) {
        if (n == null) {
            return false;
        }
        Node l = BoolNodeTools.getLargestBoolNode(n);
        if (l instanceof AAndBoolTerm) {
            return true;
        }
        if (l instanceof ATermBoolExpression) {
            l = ((ATermBoolExpression)l).getBoolTerm();
            return BoolNodeTools.isAnd(l);
        }
        return false;
    }

    public static boolean isOr(Node n) {
        if (n == null) {
            return false;
        }
        Node l = BoolNodeTools.getLargestBoolNode(n);
        if (l instanceof AOrBoolExpression) {
            return true;
        }
        if (l instanceof ATermBoolExpression) {
            l = ((ATermBoolExpression)l).getBoolTerm();
            return BoolNodeTools.isOr(l);
        }
        if (l instanceof AEqualityBoolTerm) {
            l = ((AEqualityBoolTerm)l).getEquality();
            return BoolNodeTools.isOr(l);
        }
        return false;
    }

    public static boolean isXor(Node n) {
        return n != null && BoolNodeTools.getLargestBoolNode(n) instanceof AXorBoolExpression;
    }

    public static boolean isNot(Node n) {
        return n != null && BoolNodeTools.getLargestBoolNode(n) instanceof ANegateUnaryExp;
    }

    public static boolean isTrue(Node n) {
        return n != null && BoolNodeTools.getLargestBoolNode(n) instanceof ATrueBooleanliteral;
    }

    public static boolean isFalse(Node n) {
        return n != null && BoolNodeTools.getLargestBoolNode(n) instanceof AFalseBooleanliteral;
    }

    public static boolean isComposite(Node n) {
        return BoolNodeTools.isAnd(n) || BoolNodeTools.isOr(n) || BoolNodeTools.isXor(n);
    }

    public static ANeqEquality negate(AEqEquality node) {
        ISourceCodeLocation loc = BoolNodeTools.getLocation((Node)node.getEqual());
        AEqEquality clone = (AEqEquality)node.clone();
        ANeqEquality neq = new ANeqEquality(clone.getEquality(), new TNotequal(loc.getLineNumber(), loc.getColumnNumber()), clone.getRelational());
        return neq;
    }

    public static AEqEquality negate(ANeqEquality node) {
        ISourceCodeLocation loc = BoolNodeTools.getLocation((Node)node.getNotequal());
        ANeqEquality clone = (ANeqEquality)node.clone();
        AEqEquality eq = new AEqEquality(clone.getEquality(), new TEqual(loc.getLineNumber(), loc.getColumnNumber()), clone.getRelational());
        return eq;
    }

    public static PEquality negate(PEquality node) {
        ARelationalEquality clone;
        if (node instanceof AEqEquality) {
            return BoolNodeTools.negate((AEqEquality)node);
        }
        if (node instanceof ANeqEquality) {
            return BoolNodeTools.negate((ANeqEquality)node);
        }
        ARelationalEquality peq = clone = (ARelationalEquality)node.clone();
        AEqualityBoolTerm pbt = new AEqualityBoolTerm((PEquality)peq);
        ATermBoolExpression pbe = new ATermBoolExpression((PBoolTerm)pbt);
        AExpressionFactor pf = new AExpressionFactor(new TLParenthese(), (PBoolExpression)pbe, new TRParenthese());
        AFactorPostfixExp ppe = new AFactorPostfixExp((PFactor)pf);
        APostfixExpUnaryExp pue = new APostfixExpUnaryExp((PPostfixExp)ppe);
        ANegateUnaryExp npue = new ANegateUnaryExp(new TNot(), (PUnaryExp)pue);
        AUnaryTerm pt = new AUnaryTerm((PUnaryExp)npue);
        ATermMathExpression pme = new ATermMathExpression((PTerm)pt);
        AMathRelational pr = new AMathRelational((PMathExpression)pme);
        ARelationalEquality pe = new ARelationalEquality((PRelational)pr);
        return pe;
    }

    public static PRelational negate(PRelational node) {
        if (node instanceof ALtRelational) {
            ALtRelational n = (ALtRelational)node.clone();
            TLess l = n.getLess();
            TGreaterequal g = new TGreaterequal(l.getLine(), l.getPos());
            AGteqRelational r = new AGteqRelational(n.getRelational(), g, n.getMathExpression());
            return r;
        }
        if (node instanceof ALteqRelational) {
            ALteqRelational n = (ALteqRelational)node.clone();
            TLessequal l = n.getLessequal();
            TGreater g = new TGreater(l.getLine(), l.getPos());
            AGtRelational r = new AGtRelational(n.getRelational(), g, n.getMathExpression());
            return r;
        }
        if (node instanceof AGtRelational) {
            AGtRelational n = (AGtRelational)node.clone();
            TGreater g = n.getGreater();
            TLessequal l = new TLessequal(g.getLine(), g.getPos());
            ALteqRelational r = new ALteqRelational(n.getRelational(), l, n.getMathExpression());
            return r;
        }
        if (node instanceof AGteqRelational) {
            AGteqRelational n = (AGteqRelational)node.clone();
            TGreaterequal g = n.getGreaterequal();
            TLess l = new TLess(g.getLine(), g.getPos());
            ALtRelational r = new ALtRelational(n.getRelational(), l, n.getMathExpression());
            return r;
        }
        if (node instanceof AMathRelational) {
            AMathRelational n = (AMathRelational)node.clone();
            return n;
        }
        return node;
    }

    public static PUnaryExp negate(APostfixExpUnaryExp node) {
        ISourceCodeLocation loc = BoolNodeTools.getLocation((Node)node);
        APostfixExpUnaryExp clone = (APostfixExpUnaryExp)node.clone();
        ANegateUnaryExp n = new ANegateUnaryExp(new TNot(loc.getLineNumber(), loc.getColumnNumber()), (PUnaryExp)clone);
        return n;
    }

    public static PUnaryExp negate(ANegateUnaryExp node) {
        return (PUnaryExp)node.getUnaryExp().clone();
    }

    public static PUnaryExp negate(PUnaryExp node) {
        if (node instanceof APostfixExpUnaryExp) {
            return BoolNodeTools.negate((APostfixExpUnaryExp)node);
        }
        if (node instanceof ANegateUnaryExp) {
            return BoolNodeTools.negate((ANegateUnaryExp)node);
        }
        return null;
    }

    public static PBooleanliteral negate(PBooleanliteral node) {
        Node clone = (Node)node.clone();
        if (BoolNodeTools.isTrue(clone)) {
            ATrueBooleanliteral t = (ATrueBooleanliteral)clone;
            TTrue tt = t.getTrue();
            ISourceCodeLocation loc = NodeTools.getLocation((Node)tt);
            AFalseBooleanliteral f = new AFalseBooleanliteral(new TFalse(loc.getLineNumber(), loc.getColumnNumber()));
            return f;
        }
        AFalseBooleanliteral f = (AFalseBooleanliteral)clone;
        TFalse tf = f.getFalse();
        ISourceCodeLocation loc = NodeTools.getLocation((Node)tf);
        ATrueBooleanliteral t = new ATrueBooleanliteral(new TTrue(loc.getLineNumber(), loc.getColumnNumber()));
        return t;
    }

    static class LargestSearch
    extends DepthFirstAdapter {
        private Node largest;
        private final Node toSearch;

        private LargestSearch(Node n) {
            this.toSearch = n;
        }

        protected Node getLargestBoolNode() {
            if (this.largest == null) {
                this.toSearch.apply((Switch)this);
            }
            return this.largest == null ? this.toSearch : this.largest;
        }

        public void caseABoolexpExpression(ABoolexpExpression node) {
            super.caseABoolexpExpression(node);
        }

        public void caseAAndBoolTerm(AAndBoolTerm node) {
            this.largest = node;
        }

        public void caseABoolliteralFactor(ABoolliteralFactor node) {
            this.largest = node;
            super.caseABoolliteralFactor(node);
        }

        public void caseAXorBoolExpression(AXorBoolExpression node) {
            this.largest = node;
        }

        public void caseAEqEquality(AEqEquality node) {
            this.largest = node;
        }

        public void caseAEqualityBoolTerm(AEqualityBoolTerm node) {
            this.largest = node;
            super.caseAEqualityBoolTerm(node);
        }

        public void caseAFalseBooleanliteral(AFalseBooleanliteral node) {
            this.largest = node;
        }

        public void caseANegateUnaryExp(ANegateUnaryExp node) {
            this.largest = node;
        }

        public void caseANeqEquality(ANeqEquality node) {
            this.largest = node;
        }

        public void caseAOrBoolExpression(AOrBoolExpression node) {
            this.largest = node;
        }

        public void caseALtRelational(ALtRelational node) {
            this.largest = node;
        }

        public void caseALteqRelational(ALteqRelational node) {
            this.largest = node;
        }

        public void caseAGtRelational(AGtRelational node) {
            this.largest = node;
        }

        public void caseAGteqRelational(AGteqRelational node) {
            this.largest = node;
        }

        public void caseATrueBooleanliteral(ATrueBooleanliteral node) {
            this.largest = node;
        }

        public void caseTIdentifier(TIdentifier node) {
            this.largest = node;
        }
    }
}

