/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checks.bool;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.ast.AdvancedPositionFinder;
import kenya.eclipse.ast.NodeToString;
import kenya.eclipse.ast.NodeTools;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentModificationOperation;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentTextOperation;
import kenya.eclipse.style.StyleWarningResolution;
import kenya.eclipse.style.checkerimpl.AbstractStyleChecker;
import kenya.eclipse.style.checks.IdentifierSearch;
import kenya.eclipse.style.checks.bool.BoolNodeTools;
import kenya.eclipse.style.checks.bool.SingleVariableExpressionChecker;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AAndBoolTerm;
import minijava.node.ABoolexpExpression;
import minijava.node.ABoolliteralFactor;
import minijava.node.AEqEquality;
import minijava.node.AEqualityBoolTerm;
import minijava.node.AExpressionFactor;
import minijava.node.AFactorPostfixExp;
import minijava.node.AFalseBooleanliteral;
import minijava.node.AGtRelational;
import minijava.node.AGteqRelational;
import minijava.node.ALtRelational;
import minijava.node.ALteqRelational;
import minijava.node.AMathRelational;
import minijava.node.ANegateUnaryExp;
import minijava.node.ANeqEquality;
import minijava.node.AOrBoolExpression;
import minijava.node.APostfixExpUnaryExp;
import minijava.node.ARelationalEquality;
import minijava.node.ATermBoolExpression;
import minijava.node.ATermMathExpression;
import minijava.node.ATrueBooleanliteral;
import minijava.node.AUnaryTerm;
import minijava.node.AXorBoolExpression;
import minijava.node.Node;
import minijava.node.PBoolExpression;
import minijava.node.PBoolTerm;
import minijava.node.PBooleanliteral;
import minijava.node.PEquality;
import minijava.node.PFactor;
import minijava.node.PMathExpression;
import minijava.node.PPostfixExp;
import minijava.node.PRelational;
import minijava.node.PTerm;
import minijava.node.PUnaryExp;
import minijava.node.Switch;
import minijava.node.TFalse;
import minijava.node.TLParenthese;
import minijava.node.TNot;
import minijava.node.TRParenthese;
import minijava.node.TTrue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;

public class BooleanExpressionChecker
extends AbstractStyleChecker {
    private static final String MESSAGE = "The boolean expression \"{0}\" can be simplified. It can be rewritten as \"{1}\"";

    public void configure(Map customAttributes) {
    }

    public void performCheck(ICheckedCode code, final IFile file) {
        IFunction[] functions = code.getFunctions();
        final HashMap<Node, Node> warnings = new HashMap<Node, Node>();
        int i = 0;
        while (i < functions.length) {
            IFunction fun = functions[i];
            Node n = (Node)fun.getDeclarationNode().getBlock().clone();
            List l = new BooleanSearch(n).getBooleans();
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                if (AbstractStyleChecker.overlapsWithError(node, code)) continue;
                Node temp = (Node)node.clone();
                ReductionSearch rs = new ReductionSearch(node);
                try {
                    boolean _ret = rs.isReducible();
                    Node _reduced = rs.getReducedNode();
                    if (!_ret) continue;
                    warnings.put(temp, _reduced);
                }
                catch (Exception e) {
                    KenyaPlugin.log(e);
                }
            }
            ++i;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Set s = warnings.entrySet();
                Iterator it = s.iterator();
                while (it.hasNext()) {
                    Map.Entry pair = it.next();
                    Node b4 = (Node)pair.getKey();
                    Node after = (Node)pair.getValue();
                    IDocument doc = BooleanExpressionChecker.access$0(file);
                    ISourceCodeLocation loc = AdvancedPositionFinder.getFullLocation(b4, doc);
                    String msg = MessageFormat.format(BooleanExpressionChecker.MESSAGE, NodeToString.toString(b4), NodeToString.toString(after));
                    IMarker m = BooleanExpressionChecker.access$1(file, loc, msg);
                    String label = new String(NodeToString.toString(after));
                    if (BooleanExpressionChecker.this.fResolutionMap == null) {
                        BooleanExpressionChecker.this.fResolutionMap = new HashMap(s.size());
                    }
                    ReductionMarkerResolution resolution = new ReductionMarkerResolution(label, m, label);
                    BooleanExpressionChecker.this.fResolutionMap.put(m, new ReductionMarkerResolution[]{resolution});
                }
            }
        };
        BooleanExpressionChecker.runMarkerUpdate(runnable);
    }

    static /* synthetic */ IDocument access$0(IFile iFile) {
        return AbstractStyleChecker.getDocument(iFile);
    }

    static /* synthetic */ IMarker access$1(IFile iFile, ISourceCodeLocation iSourceCodeLocation, String string) throws CoreException {
        return AbstractStyleChecker.createKenyaStyleMarker(iFile, iSourceCodeLocation, string);
    }

    private class BooleanSearch
    extends DepthFirstAdapter {
        private final Node toSearch;
        private ArrayList list;

        public BooleanSearch(Node n) {
            this.toSearch = n;
        }

        public List getBooleans() {
            if (this.list == null) {
                this.list = new ArrayList();
                this.toSearch.apply((Switch)this);
            }
            return this.list;
        }

        public void caseAAndBoolTerm(AAndBoolTerm node) {
            this.inAAndBoolTerm(node);
            this.list.add(node);
            this.outAAndBoolTerm(node);
        }

        public void caseAOrBoolExpression(AOrBoolExpression node) {
            this.inAOrBoolExpression(node);
            this.list.add(node);
            this.outAOrBoolExpression(node);
        }

        public void caseANegateUnaryExp(ANegateUnaryExp node) {
            this.inANegateUnaryExp(node);
            this.list.add(node);
            this.outANegateUnaryExp(node);
        }

        public void caseAEqualityBoolTerm(AEqualityBoolTerm node) {
            this.inAEqualityBoolTerm(node);
            this.list.add(node);
            this.outAEqualityBoolTerm(node);
        }

        public void caseAXorBoolExpression(AXorBoolExpression node) {
            this.inAXorBoolExpression(node);
            this.list.add(node);
            this.outAXorBoolExpression(node);
        }
    }

    private class ReductionSearch
    extends DepthFirstAdapter {
        private boolean _ret = false;
        private boolean tried = false;
        private Node _reduced;
        private final Node toSearch;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;

        public ReductionSearch(Node n) {
            this.toSearch = n;
        }

        public boolean isReducible() {
            if (!this.tried) {
                this.toSearch.apply((Switch)this);
                this.tried = true;
            }
            return this._ret;
        }

        public Node getReducedNode() {
            return this.isReducible() ? this._reduced : this.toSearch;
        }

        public void caseAAndBoolTerm(AAndBoolTerm node) {
            AAndBoolTerm nn;
            PEquality rep;
            this.inAAndBoolTerm(node);
            PBoolTerm term = node.getBoolTerm();
            PEquality eq = node.getEquality();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("minijava.node.PBoolTerm");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> boolterm = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("minijava.node.PEquality");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> peq = clazz2;
            ReductionSearch s1 = new ReductionSearch((Node)term.clone());
            ReductionSearch s2 = new ReductionSearch((Node)eq.clone());
            Node n1 = BoolNodeTools.getLargestBoolNode(s1.getReducedNode());
            Node n2 = BoolNodeTools.getLargestBoolNode(s2.getReducedNode());
            boolean bl = this._ret = s1.isReducible() || s2.isReducible();
            if (BoolNodeTools.isTrue(n1) || BoolNodeTools.isFalse(n2)) {
                rep = (PEquality)BoolNodeTools.getParent(n2, peq);
                AEqualityBoolTerm ebt = new AEqualityBoolTerm(rep);
                node.replaceBy((Node)ebt);
                this._reduced = ebt;
            } else if (BoolNodeTools.isTrue(n2) || BoolNodeTools.isFalse(n1) || BoolNodeTools.limitedAreEqual(n1, n2)) {
                rep = BoolNodeTools.getParent(n1, boolterm);
                node.replaceBy((Node)rep);
                this._reduced = rep;
            } else if (this._ret) {
                term.replaceBy((Node)((PBoolTerm)BoolNodeTools.getParent(n1, boolterm)));
                eq.replaceBy((Node)((PEquality)BoolNodeTools.getParent(n2, peq)));
                this._reduced = node;
            } else {
                this._reduced = node;
                return;
            }
            if (this._reduced instanceof AAndBoolTerm && BoolNodeTools.limitedAreEqual((Node)(nn = (AAndBoolTerm)this._reduced).getBoolTerm(), (Node)nn.getEquality())) {
                this._reduced.replaceBy((Node)nn.getBoolTerm());
            }
            this._ret = true;
            this.outAAndBoolTerm(node);
        }

        public void caseAOrBoolExpression(AOrBoolExpression node) {
            AOrBoolExpression nn;
            this.inAOrBoolExpression(node);
            PBoolExpression exp = node.getBoolExpression();
            PBoolTerm term = node.getBoolTerm();
            ReductionSearch s1 = new ReductionSearch((Node)exp.clone());
            ReductionSearch s2 = new ReductionSearch((Node)term.clone());
            Node n1 = BoolNodeTools.getLargestBoolNode(s1.getReducedNode());
            Node n2 = BoolNodeTools.getLargestBoolNode(s2.getReducedNode());
            boolean bl = this._ret = s1.isReducible() || s2.isReducible();
            if (BoolNodeTools.isTrue(n1) || BoolNodeTools.isFalse(n2) || BoolNodeTools.limitedAreEqual(n1, n2)) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("minijava.node.PBoolExpression");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Node rep = BoolNodeTools.getParent(n1, clazz);
                node.replaceBy(rep);
                this._reduced = rep;
            } else if (BoolNodeTools.isTrue(n2) || BoolNodeTools.isFalse(n1)) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("minijava.node.PBoolTerm");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ATermBoolExpression tbe = new ATermBoolExpression((PBoolTerm)BoolNodeTools.getParent(n2, clazz));
                node.replaceBy((Node)tbe);
                this._reduced = tbe;
            } else if (this._ret) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("minijava.node.PBoolExpression");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                exp.replaceBy(BoolNodeTools.getParent(n1, clazz));
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("minijava.node.PBoolTerm");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                term.replaceBy((Node)((PBoolTerm)BoolNodeTools.getParent(n2, clazz2)));
                this._reduced = node;
            } else {
                this._reduced = node;
                return;
            }
            if (this._reduced instanceof AOrBoolExpression && BoolNodeTools.limitedAreEqual((Node)(nn = (AOrBoolExpression)this._reduced).getBoolTerm(), (Node)nn.getBoolExpression())) {
                this._reduced.replaceBy((Node)node.getBoolTerm());
            }
            this._ret = true;
            this.outAOrBoolExpression(node);
        }

        public void caseABoolexpExpression(ABoolexpExpression node) {
            this.inABoolexpExpression(node);
            node.getBoolExpression().apply((Switch)this);
            this.outABoolexpExpression(node);
        }

        public void caseANegateUnaryExp(ANegateUnaryExp node) {
            this.inANegateUnaryExp(node);
            PUnaryExp unary = node.getUnaryExp();
            ReductionSearch s1 = new ReductionSearch((Node)unary.clone());
            Node n1 = BoolNodeTools.getLargestBoolNode(s1.getReducedNode());
            this._ret = s1.isReducible();
            if (BoolNodeTools.isTrue(n1) || BoolNodeTools.isFalse(n1)) {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("minijava.node.PBooleanliteral");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PBooleanliteral l = BoolNodeTools.negate((PBooleanliteral)BoolNodeTools.getParent(n1, clazz));
                ABoolliteralFactor f = new ABoolliteralFactor(l);
                AFactorPostfixExp p = new AFactorPostfixExp((PFactor)f);
                APostfixExpUnaryExp e = new APostfixExpUnaryExp((PPostfixExp)p);
                node.replaceBy((Node)e);
                this._reduced = e;
                this._ret = true;
            } else if (this._ret) {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("minijava.node.PUnaryExp");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PUnaryExp rep = (PUnaryExp)BoolNodeTools.getParent(n1, clazz);
                node.getUnaryExp().replaceBy((Node)rep);
                this._reduced = node;
                this._ret = true;
            } else if (BoolNodeTools.isNot(n1)) {
                ANegateUnaryExp u = (ANegateUnaryExp)BoolNodeTools.getLargestBoolNode(n1);
                PUnaryExp rep = u.getUnaryExp();
                node.replaceBy((Node)rep);
                this._reduced = rep;
                this._ret = true;
            } else {
                this._reduced = node;
            }
            this.outANegateUnaryExp(node);
        }

        public void caseAEqEquality(AEqEquality node) {
            this.inAEqEquality(node);
            PEquality eq = node.getEquality();
            PRelational rel = node.getRelational();
            ReductionSearch s1 = new ReductionSearch((Node)eq.clone());
            ReductionSearch s2 = new ReductionSearch((Node)rel.clone());
            Node n1 = BoolNodeTools.getLargestBoolNode(s1.getReducedNode());
            Node n2 = BoolNodeTools.getLargestBoolNode(s2.getReducedNode());
            boolean bl = this._ret = s1.isReducible() || s2.isReducible();
            if (BoolNodeTools.isFalse(n1) && BoolNodeTools.isFalse(n2) || BoolNodeTools.isTrue(n1) && BoolNodeTools.isTrue(n2) || BoolNodeTools.limitedAreEqual(n1, n2)) {
                ARelationalEquality releq = new ARelationalEquality();
                ISourceCodeLocation loc = NodeTools.getLocation((Node)node);
                TTrue tt = new TTrue(loc.getLineNumber(), loc.getColumnNumber());
                ATrueBooleanliteral literal = new ATrueBooleanliteral(tt);
                ABoolliteralFactor lfac = new ABoolliteralFactor((PBooleanliteral)literal);
                AFactorPostfixExp pexp = new AFactorPostfixExp((PFactor)lfac);
                APostfixExpUnaryExp unaryexp = new APostfixExpUnaryExp((PPostfixExp)pexp);
                AUnaryTerm uterm = new AUnaryTerm((PUnaryExp)unaryexp);
                ATermMathExpression mexp = new ATermMathExpression((PTerm)uterm);
                AMathRelational mrel = new AMathRelational((PMathExpression)mexp);
                releq.setRelational((PRelational)mrel);
                node.replaceBy((Node)releq);
                this._reduced = releq;
            } else if (BoolNodeTools.isTrue(n2) && !BoolNodeTools.isFalse(n1)) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("minijava.node.PEquality");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Node n = BoolNodeTools.getParent(n1, clazz);
                node.replaceBy(n);
                this._reduced = n;
            } else if (BoolNodeTools.isTrue(n1) && !BoolNodeTools.isFalse(n2)) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("minijava.node.PRelational");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PRelational mrel = (PRelational)BoolNodeTools.getParent(n2, clazz);
                ARelationalEquality releq = new ARelationalEquality(mrel);
                node.replaceBy((Node)releq);
                this._reduced = releq;
            } else if (BoolNodeTools.isFalse(n2) && !BoolNodeTools.isTrue(n1)) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("minijava.node.PEquality");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PEquality neg = BoolNodeTools.negate((PEquality)BoolNodeTools.getParent(n1, clazz));
                node.replaceBy((Node)neg);
                this._reduced = neg;
            } else if (BoolNodeTools.isFalse(n1) && !BoolNodeTools.isTrue(n2)) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("minijava.node.PRelational");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PRelational mrel = (PRelational)BoolNodeTools.getParent(n2, clazz);
                ARelationalEquality releq = new ARelationalEquality(mrel);
                PEquality neg = BoolNodeTools.negate((PEquality)releq);
                node.replaceBy((Node)neg);
                this._reduced = neg;
            } else if (SingleVariableExpressionChecker.isSingleVariableExpression(n1) && SingleVariableExpressionChecker.isSingleVariableExpression(n2) && !IdentifierSearch.isIdentifier(n1) && !IdentifierSearch.isIdentifier(n2) && !BoolNodeTools.limitedAreEqual(n1, n2)) {
                ARelationalEquality releq = new ARelationalEquality();
                ISourceCodeLocation loc = NodeTools.getLocation((Node)node);
                TFalse tf = new TFalse(loc.getLineNumber(), loc.getColumnNumber());
                AFalseBooleanliteral literal = new AFalseBooleanliteral(tf);
                ABoolliteralFactor lfac = new ABoolliteralFactor((PBooleanliteral)literal);
                AFactorPostfixExp pexp = new AFactorPostfixExp((PFactor)lfac);
                APostfixExpUnaryExp unaryexp = new APostfixExpUnaryExp((PPostfixExp)pexp);
                AUnaryTerm uterm = new AUnaryTerm((PUnaryExp)unaryexp);
                ATermMathExpression mexp = new ATermMathExpression((PTerm)uterm);
                AMathRelational mrel = new AMathRelational((PMathExpression)mexp);
                releq.setRelational((PRelational)mrel);
                node.replaceBy((Node)releq);
                this._reduced = releq;
            } else {
                this._reduced = node;
                return;
            }
            this._ret = true;
            this.outAEqEquality(node);
        }

        public void caseANeqEquality(ANeqEquality node) {
            this.inANeqEquality(node);
            PEquality eq = node.getEquality();
            PRelational rel = node.getRelational();
            ReductionSearch s1 = new ReductionSearch((Node)eq.clone());
            ReductionSearch s2 = new ReductionSearch((Node)rel.clone());
            Node n1 = BoolNodeTools.getLargestBoolNode(s1.getReducedNode());
            Node n2 = BoolNodeTools.getLargestBoolNode(s2.getReducedNode());
            boolean bl = this._ret = s1.isReducible() || s2.isReducible();
            if (BoolNodeTools.isFalse(n1) && BoolNodeTools.isFalse(n2) || BoolNodeTools.isTrue(n1) && BoolNodeTools.isTrue(n2) || BoolNodeTools.limitedAreEqual(n1, n2)) {
                ARelationalEquality releq = new ARelationalEquality();
                ISourceCodeLocation loc = NodeTools.getLocation((Node)node);
                TFalse tf = new TFalse(loc.getLineNumber(), loc.getColumnNumber());
                AFalseBooleanliteral literal = new AFalseBooleanliteral(tf);
                ABoolliteralFactor lfac = new ABoolliteralFactor((PBooleanliteral)literal);
                AFactorPostfixExp pexp = new AFactorPostfixExp((PFactor)lfac);
                APostfixExpUnaryExp unaryexp = new APostfixExpUnaryExp((PPostfixExp)pexp);
                AUnaryTerm uterm = new AUnaryTerm((PUnaryExp)unaryexp);
                ATermMathExpression mexp = new ATermMathExpression((PTerm)uterm);
                AMathRelational mrel = new AMathRelational((PMathExpression)mexp);
                releq.setRelational((PRelational)mrel);
                node.replaceBy((Node)releq);
                this._reduced = releq;
            } else if (BoolNodeTools.isFalse(n2)) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("minijava.node.PEquality");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Node n = BoolNodeTools.getParent(n1, clazz);
                node.replaceBy(n);
                this._reduced = n;
            } else if (BoolNodeTools.isFalse(n1)) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("minijava.node.PRelational");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PRelational mrel = (PRelational)BoolNodeTools.getParent(n2, clazz);
                ARelationalEquality releq = new ARelationalEquality(mrel);
                node.replaceBy((Node)releq);
                this._reduced = releq;
            } else if (BoolNodeTools.isTrue(n2)) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("minijava.node.PEquality");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PEquality neg = BoolNodeTools.negate((PEquality)BoolNodeTools.getParent(n1, clazz));
                node.replaceBy((Node)neg);
                this._reduced = neg;
            } else if (BoolNodeTools.isTrue(n1)) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("minijava.node.PRelational");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PRelational mrel = (PRelational)BoolNodeTools.getParent(n2, clazz);
                ARelationalEquality releq = new ARelationalEquality(mrel);
                PEquality neg = BoolNodeTools.negate((PEquality)releq);
                node.replaceBy((Node)neg);
                this._reduced = neg;
            } else {
                this._reduced = node;
                return;
            }
            this._ret = true;
            this.outANeqEquality(node);
        }

        public void caseAFalseBooleanliteral(AFalseBooleanliteral node) {
            this.inAFalseBooleanliteral(node);
            this.outAFalseBooleanliteral(node);
        }

        public void caseATrueBooleanliteral(ATrueBooleanliteral node) {
            this.inATrueBooleanliteral(node);
            this.outATrueBooleanliteral(node);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void caseAXorBoolExpression(AXorBoolExpression node) {
            this.inAXorBoolExpression(node);
            PBoolExpression exp = node.getBoolExpression();
            PBoolTerm term = node.getBoolTerm();
            ReductionSearch s1 = new ReductionSearch((Node)exp.clone());
            ReductionSearch s2 = new ReductionSearch((Node)term.clone());
            Node n1 = BoolNodeTools.getLargestBoolNode(s1.getReducedNode());
            Node n2 = BoolNodeTools.getLargestBoolNode(s2.getReducedNode());
            boolean bl = this._ret = s1.isReducible() || s2.isReducible();
            if (BoolNodeTools.isFalse(n1)) {
                ATermBoolExpression tbe = new ATermBoolExpression(term);
                node.replaceBy((Node)tbe);
                this._reduced = tbe;
            } else if (BoolNodeTools.isFalse(n2)) {
                node.replaceBy((Node)exp);
                this._reduced = exp;
            } else if (BoolNodeTools.isTrue(n1) && BoolNodeTools.isTrue(n2) || BoolNodeTools.isFalse(n1) && BoolNodeTools.isFalse(n2) || BoolNodeTools.limitedAreEqual(n1, n2)) {
                ATermBoolExpression tbe = new ATermBoolExpression();
                ISourceCodeLocation loc = NodeTools.getLocation((Node)node);
                TFalse tf = new TFalse(loc.getLineNumber(), loc.getColumnNumber());
                AFalseBooleanliteral literal = new AFalseBooleanliteral(tf);
                ABoolliteralFactor lfac = new ABoolliteralFactor((PBooleanliteral)literal);
                AFactorPostfixExp pexp = new AFactorPostfixExp((PFactor)lfac);
                APostfixExpUnaryExp unaryexp = new APostfixExpUnaryExp((PPostfixExp)pexp);
                AUnaryTerm uterm = new AUnaryTerm((PUnaryExp)unaryexp);
                ATermMathExpression mexp = new ATermMathExpression((PTerm)uterm);
                AMathRelational mrel = new AMathRelational((PMathExpression)mexp);
                ARelationalEquality releq = new ARelationalEquality((PRelational)mrel);
                AEqualityBoolTerm ebt = new AEqualityBoolTerm((PEquality)releq);
                tbe.setBoolTerm((PBoolTerm)ebt);
                node.replaceBy((Node)tbe);
                this._reduced = tbe;
            } else if (BoolNodeTools.isTrue(n1) || BoolNodeTools.isTrue(n2)) {
                PBoolExpression repl1;
                PUnaryExp p;
                boolean negated = false;
                if (BoolNodeTools.isTrue(n1)) {
                    Class<?> clazz;
                    if (BoolNodeTools.isNot(n2)) {
                        Class<?> clazz2 = class$4;
                        if (clazz2 == null) {
                            Class<?> clazz3;
                            try {
                                clazz3 = Class.forName("minijava.node.PUnaryExp");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz2 = class$4 = clazz3;
                        }
                        p = BoolNodeTools.negate((PUnaryExp)BoolNodeTools.getParent(n2, clazz2));
                        n2.replaceBy((Node)p);
                        n2 = p;
                        negated = true;
                    }
                    if ((clazz = class$0) == null) {
                        Class<?> clazz4;
                        try {
                            clazz4 = Class.forName("minijava.node.PBoolTerm");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz4;
                    }
                    PBoolTerm pbt = (PBoolTerm)BoolNodeTools.getParent(n2, clazz);
                    repl1 = new ATermBoolExpression(pbt);
                } else {
                    Class<?> clazz;
                    if (BoolNodeTools.isNot(n1)) {
                        Class<?> clazz5 = class$4;
                        if (clazz5 == null) {
                            Class<?> clazz6;
                            try {
                                clazz6 = Class.forName("minijava.node.PUnaryExp");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz5 = class$4 = clazz6;
                        }
                        p = BoolNodeTools.negate((PUnaryExp)BoolNodeTools.getParent(n1, clazz5));
                        n1.replaceBy((Node)p);
                        n1 = p;
                        negated = true;
                    }
                    if ((clazz = class$2) == null) {
                        Class<?> clazz7;
                        try {
                            clazz7 = Class.forName("minijava.node.PBoolExpression");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$2 = clazz7;
                    }
                    repl1 = (PBoolExpression)BoolNodeTools.getParent(n1, clazz);
                }
                if (!negated) {
                    ATermBoolExpression repl = new ATermBoolExpression();
                    ISourceCodeLocation loc = BoolNodeTools.getLocation((Node)repl1);
                    int line = loc.getLineNumber();
                    int col = loc.getColumnNumber();
                    TLParenthese lparen = new TLParenthese(line, col + 1);
                    TRParenthese rparen = new TRParenthese(line, col + 1 + loc.getTokenLength());
                    AExpressionFactor aef = new AExpressionFactor(lparen, repl1, rparen);
                    AFactorPostfixExp afpe = new AFactorPostfixExp((PFactor)aef);
                    APostfixExpUnaryExp apeue = new APostfixExpUnaryExp((PPostfixExp)afpe);
                    TNot not = new TNot(line, col);
                    ANegateUnaryExp anue = new ANegateUnaryExp(not, (PUnaryExp)apeue);
                    AUnaryTerm aut = new AUnaryTerm((PUnaryExp)anue);
                    ATermMathExpression atme = new ATermMathExpression((PTerm)aut);
                    AMathRelational amr = new AMathRelational((PMathExpression)atme);
                    ARelationalEquality are = new ARelationalEquality((PRelational)amr);
                    AEqualityBoolTerm aebt = new AEqualityBoolTerm((PEquality)are);
                    repl.setBoolTerm((PBoolTerm)aebt);
                    node.replaceBy((Node)repl);
                    this._reduced = repl;
                } else {
                    node.replaceBy((Node)repl1);
                    this._reduced = repl1;
                }
            } else if (BoolNodeTools.isNot(n1) || BoolNodeTools.isNot(n2)) {
                PUnaryExp neg;
                boolean thisIsTrue = false;
                if (BoolNodeTools.isNot(n1)) {
                    Class<?> clazz = class$4;
                    if (clazz == null) {
                        Class<?> clazz8;
                        try {
                            clazz8 = Class.forName("minijava.node.PUnaryExp");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$4 = clazz8;
                    }
                    neg = (PUnaryExp)BoolNodeTools.getParent(n1, clazz);
                    neg = BoolNodeTools.negate(neg);
                    thisIsTrue = BoolNodeTools.limitedAreEqual((Node)neg, n2);
                } else {
                    Class<?> clazz = class$4;
                    if (clazz == null) {
                        Class<?> clazz9;
                        try {
                            clazz9 = Class.forName("minijava.node.PUnaryExp");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$4 = clazz9;
                    }
                    neg = (PUnaryExp)BoolNodeTools.getParent(n2, clazz);
                    neg = BoolNodeTools.negate(neg);
                    thisIsTrue = BoolNodeTools.limitedAreEqual(n1, (Node)neg);
                }
                if (!thisIsTrue) {
                    this._ret = false;
                    return;
                }
                ATermBoolExpression tbe = new ATermBoolExpression();
                ISourceCodeLocation loc = NodeTools.getLocation((Node)node);
                TTrue tt = new TTrue(loc.getLineNumber(), loc.getColumnNumber());
                ATrueBooleanliteral literal = new ATrueBooleanliteral(tt);
                ABoolliteralFactor lfac = new ABoolliteralFactor((PBooleanliteral)literal);
                AFactorPostfixExp pexp = new AFactorPostfixExp((PFactor)lfac);
                APostfixExpUnaryExp unaryexp = new APostfixExpUnaryExp((PPostfixExp)pexp);
                AUnaryTerm uterm = new AUnaryTerm((PUnaryExp)unaryexp);
                ATermMathExpression mexp = new ATermMathExpression((PTerm)uterm);
                AMathRelational mrel = new AMathRelational((PMathExpression)mexp);
                ARelationalEquality releq = new ARelationalEquality((PRelational)mrel);
                AEqualityBoolTerm ebt = new AEqualityBoolTerm((PEquality)releq);
                tbe.setBoolTerm((PBoolTerm)ebt);
                node.replaceBy((Node)tbe);
                this._reduced = tbe;
            } else {
                if (!this._ret) {
                    this._reduced = node;
                    return;
                }
                Class<?> clazz = class$2;
                if (clazz == null) {
                    Class<?> clazz10;
                    try {
                        clazz10 = Class.forName("minijava.node.PBoolExpression");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$2 = clazz10;
                }
                exp.replaceBy(BoolNodeTools.getParent(n1, clazz));
                Class<?> clazz11 = class$0;
                if (clazz11 == null) {
                    Class<?> clazz12;
                    try {
                        clazz12 = Class.forName("minijava.node.PBoolTerm");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz11 = class$0 = clazz12;
                }
                term.replaceBy((Node)((PBoolTerm)BoolNodeTools.getParent(n2, clazz11)));
                this._reduced = node;
            }
            this._ret = true;
            this.outAXorBoolExpression(node);
        }

        public void caseAExpressionFactor(AExpressionFactor node) {
            this.inAExpressionFactor(node);
            node.getBoolExpression().apply((Switch)this);
            this.outAExpressionFactor(node);
        }

        public void caseALtRelational(ALtRelational node) {
            this._reduced = node;
        }

        public void caseALteqRelational(ALteqRelational node) {
            this._reduced = node;
        }

        public void caseAGtRelational(AGtRelational node) {
            this._reduced = node;
        }

        public void caseAGteqRelational(AGteqRelational node) {
            this._reduced = node;
        }
    }

    class ReductionMarkerResolution
    extends StyleWarningResolution {
        public ReductionMarkerResolution(String label, IMarker marker, String replacement) {
            super("replace with " + label, marker, new DocumentModificationOperation());
            this.fDescription = "<p><b>Explanation:</b></p><p>The given expression is complicated and might obscure the actual purpose of the statment. If it is simplified, the code becomes clearer and much easier to read and understand.</p>";
            int offset = marker.getAttribute("charStart", -1);
            int length = marker.getAttribute("charEnd", -1) - offset;
            if (offset >= 0) {
                this.fOperation.addOperation(DocumentTextOperation.newTextReplacement(offset, length, replacement));
            }
        }
    }
}

