/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checks.bool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kenya.eclipse.ast.AdvancedPositionFinder;
import kenya.eclipse.ast.NodeToString;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentModificationOperation;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentTextOperation;
import kenya.eclipse.style.StyleWarningResolution;
import kenya.eclipse.style.checkerimpl.AbstractStyleChecker;
import kenya.eclipse.style.checks.StatementSearch;
import kenya.eclipse.style.checks.bool.BoolNodeTools;
import kenya.eclipse.style.checks.bool.IfSearch;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import minijava.node.ABlockElseFollow;
import minijava.node.AElsePart;
import minijava.node.AIfStat;
import minijava.node.Node;
import minijava.node.PElseFollow;
import minijava.node.PUnaryExp;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class EmptyIfElseChecker
extends AbstractStyleChecker {
    public static final String IF_MESSAGE = "The 'if' part of this if statement is empty.";
    public static final String ELSE_MESSAGE = "The 'else' part of this if statement is empty.";
    static /* synthetic */ Class class$0;

    public void configure(Map customAttributes) {
    }

    public void performCheck(ICheckedCode code, final IFile file) {
        IFunction[] functions = code.getFunctions();
        ArrayList ifs = new ArrayList();
        int i = 0;
        while (i < functions.length) {
            Node n = (Node)functions[i].getDeclarationNode().clone();
            ifs.addAll(IfSearch.getIfStats(n, false));
            ++i;
        }
        if (this.fResolutionMap == null) {
            this.fResolutionMap = new HashMap(ifs.size() / 2);
        }
        Iterator ifs_iter = ifs.iterator();
        while (ifs_iter.hasNext()) {
            List statements_if;
            PElseFollow f;
            AElsePart els;
            final AIfStat stat = (AIfStat)ifs_iter.next();
            if (stat == null || (els = (AElsePart)stat.getElsePart()) == null || (f = els.getElseFollow()) == null || !(f instanceof ABlockElseFollow) || (statements_if = StatementSearch.getAllStatements((Node)stat.getBlock1())).size() != 0) continue;
            final IDocument doc = EmptyIfElseChecker.getDocument(file);
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker marker;
                    ISourceCodeLocation pp = AdvancedPositionFinder.getFullLocation((Node)stat.getIf(), doc);
                    try {
                        marker = EmptyIfElseChecker.access$0(file, pp, EmptyIfElseChecker.IF_MESSAGE);
                    }
                    catch (CoreException coreException) {
                        return;
                    }
                    DocumentModificationOperation o = new DocumentModificationOperation();
                    ISourceCodeLocation boolLocation = AdvancedPositionFinder.getFullLocation((Node)stat.getBoolExpression(), doc);
                    Position boolPos = EmptyIfElseChecker.access$1(boolLocation, doc);
                    Node exp = BoolNodeTools.getLargestBoolNode((Node)stat.getBoolExpression());
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("minijava.node.PUnaryExp");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    PUnaryExp negation = (PUnaryExp)BoolNodeTools.getParent(exp, clazz);
                    negation = BoolNodeTools.negate(negation);
                    String neg = NodeToString.toString((Node)negation);
                    o.addOperation(DocumentTextOperation.newTextReplacement(boolPos.offset, boolPos.length, neg));
                    ISourceCodeLocation block1loc = AdvancedPositionFinder.getFullLocation((Node)stat.getBlock1(), doc);
                    Position block1pos = EmptyIfElseChecker.access$1(block1loc, doc);
                    ABlockElseFollow follow = (ABlockElseFollow)f;
                    ISourceCodeLocation block2loc = AdvancedPositionFinder.getFullLocation((Node)follow, doc);
                    Position block2pos = EmptyIfElseChecker.access$1(block2loc, doc);
                    int start = block1pos.offset;
                    int length = block2pos.offset - start;
                    o.addOperation(DocumentTextOperation.newTextDeletion(start, length));
                    StyleWarningResolution res = new StyleWarningResolution(this, "replace with else block contents and negate condition", marker, o){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public String getDescription() {
                            return "<p><b>Explanation:</b></p><p>The 'if' part of this if statement is empty. Although this can be optimised by a compiler, the code would be more readable if the empty block was removed.</p>";
                        }
                    };
                    EmptyIfElseChecker.this.fResolutionMap.put(marker, res);
                }
            };
            EmptyIfElseChecker.runMarkerUpdate(runnable);
        }
    }

    static /* synthetic */ IMarker access$0(IFile iFile, ISourceCodeLocation iSourceCodeLocation, String string) throws CoreException {
        return AbstractStyleChecker.createKenyaStyleMarker(iFile, iSourceCodeLocation, string);
    }

    static /* synthetic */ Position access$1(ISourceCodeLocation iSourceCodeLocation, IDocument iDocument) {
        return AbstractStyleChecker.calculatePosition(iSourceCodeLocation, iDocument);
    }
}

