/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checks.bool;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kenya.eclipse.ast.AdvancedPositionFinder;
import kenya.eclipse.ast.NodeToString;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentModificationOperation;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentTextOperation;
import kenya.eclipse.style.StyleWarningResolution;
import kenya.eclipse.style.checkerimpl.AbstractStyleChecker;
import kenya.eclipse.style.checks.StatementSearch;
import kenya.eclipse.style.checks.bool.BoolNodeTools;
import kenya.eclipse.style.checks.bool.IfSearch;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import minijava.node.AElsePart;
import minijava.node.AIfStat;
import minijava.node.AReturnStatement;
import minijava.node.Node;
import minijava.node.PElseFollow;
import minijava.node.PExpression;
import minijava.node.PUnaryExp;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class IfReturnElseReturnChecker
extends AbstractStyleChecker {
    public static final String MESSAGE = "This 'if' statement is unnecessary and can be replaced with a single return statement";
    static /* synthetic */ Class class$0;

    public void configure(Map customAttributes) {
    }

    public void performCheck(ICheckedCode code, final IFile file) {
        IFunction[] functions = code.getFunctions();
        ArrayList ifs = new ArrayList();
        int i = 0;
        while (i < functions.length) {
            Node n = (Node)functions[i].getDeclarationNode().clone();
            ifs.addAll(IfSearch.getIfStats(n, false));
            ++i;
        }
        if (this.fResolutionMap == null) {
            this.fResolutionMap = new HashMap(ifs.size() / 2);
        }
        Iterator ifs_iter = ifs.iterator();
        while (ifs_iter.hasNext()) {
            AReturnStatement block2Returns;
            AElsePart els;
            PElseFollow f;
            AReturnStatement block1Returns;
            final AIfStat stat = (AIfStat)ifs_iter.next();
            List statements = StatementSearch.getAllStatements((Node)stat.getBlock1());
            if (statements.size() > 1) continue;
            AReturnStatement aReturnStatement = block1Returns = statements.size() == 1 && statements.get(0) instanceof AReturnStatement ? (AReturnStatement)statements.get(0) : null;
            if (block1Returns == null || (statements = StatementSearch.getAllStatements((Node)(f = (els = (AElsePart)stat.getElsePart()).getElseFollow()))).size() > 1) continue;
            AReturnStatement aReturnStatement2 = block2Returns = statements.size() == 1 && statements.get(0) instanceof AReturnStatement ? (AReturnStatement)statements.get(0) : null;
            if (block2Returns == null) continue;
            final PExpression r1e = block1Returns.getExpression();
            final PExpression r2e = block2Returns.getExpression();
            final IDocument doc = IfReturnElseReturnChecker.getDocument(file);
            ISourceCodeLocation loc = AdvancedPositionFinder.getFullLocation((Node)stat, doc);
            final Position pos = IfReturnElseReturnChecker.calculatePosition(loc, doc);
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker marker;
                    ISourceCodeLocation pp = AdvancedPositionFinder.getFullLocation((Node)stat.getIf(), doc);
                    try {
                        marker = IfReturnElseReturnChecker.access$0(file, pp, IfReturnElseReturnChecker.MESSAGE);
                    }
                    catch (CoreException coreException) {
                        return;
                    }
                    String repl = null;
                    if (BoolNodeTools.isTrue((Node)r1e) && BoolNodeTools.isFalse((Node)r2e)) {
                        repl = NodeToString.toString((Node)stat.getBoolExpression());
                    } else if (BoolNodeTools.isTrue((Node)r2e) && BoolNodeTools.isFalse((Node)r1e)) {
                        Node n = BoolNodeTools.getLargestBoolNode((Node)stat.getBoolExpression());
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("minijava.node.PUnaryExp");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        PUnaryExp unary = (PUnaryExp)BoolNodeTools.getParent(n, clazz);
                        repl = NodeToString.toString((Node)BoolNodeTools.negate(unary));
                    } else if (BoolNodeTools.limitedAreEqual((Node)r1e, (Node)r2e)) {
                        repl = NodeToString.toString((Node)r1e);
                    } else {
                        marker.delete();
                        return;
                    }
                    repl = MessageFormat.format("return {0};", repl);
                    DocumentTextOperation op = DocumentTextOperation.newTextReplacement(pos.offset, pos.length, repl);
                    DocumentModificationOperation o = new DocumentModificationOperation();
                    o.addOperation(op);
                    StyleWarningResolution res = new StyleWarningResolution(this, "replace with " + repl, marker, o){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public String getDescription() {
                            return "<p><b>Explanation:</b></p><p>You are testing whether a boolean expression is true or false and then return true or false accordingly. However, since the boolean expression itself already holds exactly that truth value, it is equivalent to simply return this expression.<br>Not only would this make the code look nicer and more concise, but it also loses you less marks for using 'bad style'! :p</p>";
                        }
                    };
                    IfReturnElseReturnChecker.this.fResolutionMap.put(marker, res);
                }
            };
            IfReturnElseReturnChecker.runMarkerUpdate(runnable);
        }
    }

    static /* synthetic */ IMarker access$0(IFile iFile, ISourceCodeLocation iSourceCodeLocation, String string) throws CoreException {
        return AbstractStyleChecker.createKenyaStyleMarker(iFile, iSourceCodeLocation, string);
    }
}

