/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checks.magic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kenya.eclipse.style.checks.magic.MagicXYZChecker;
import kenya.eclipse.style.checks.magic.NumberSearch;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import mediator.ICheckedCode;
import minijava.node.Node;
import minijava.node.Token;
import org.eclipse.core.resources.IFile;

public class MagicNumberChecker
extends MagicXYZChecker {
    private static final String MESSAGE = "The number {0} appears more than once. It would be beneficial to declare it as a constant.";
    private static final List IGNORE_NUMBERS = new ArrayList();

    static {
        IGNORE_NUMBERS.add("1");
        IGNORE_NUMBERS.add("0");
        IGNORE_NUMBERS.add("-1");
        IGNORE_NUMBERS.add("2");
    }

    public void configure(Map customAttributes) {
    }

    public void performCheck(ICheckedCode code, IFile file) {
        IFunction[] functions = code.getFunctions();
        ArrayList bigList = new ArrayList();
        int i = 0;
        while (i < functions.length) {
            IFunction fun = functions[i];
            Node n = (Node)fun.getDeclarationNode().getBlock().clone();
            bigList.addAll(NumberSearch.getNumbers(n));
            ++i;
        }
        this.step4(file, this.step3(this.step2(bigList)), MESSAGE);
    }

    protected HashMap step2(List bigList) {
        HashMap listOfPositions = new HashMap();
        while (!bigList.isEmpty()) {
            Token t = (Token)bigList.remove(0);
            String text = t.getText();
            if (IGNORE_NUMBERS.contains(text)) continue;
            if (!listOfPositions.containsKey(text)) {
                listOfPositions.put(text, new ArrayList(1));
            }
            ArrayList al = (ArrayList)listOfPositions.get(text);
            SourceCodeLocation loc = new SourceCodeLocation(t.getLine(), t.getPos(), text.length());
            al.add(loc);
        }
        return listOfPositions;
    }
}

