/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checks.magic;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kenya.eclipse.style.AutomatedNAVStyleWarningResolution;
import kenya.eclipse.style.StyleWarningResolution;
import kenya.eclipse.style.checkerimpl.AbstractStyleChecker;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import minijava.node.Token;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class MagicXYZChecker
extends AbstractStyleChecker {
    protected HashMap step2(List bigList) {
        HashMap listOfPositions = new HashMap();
        while (!bigList.isEmpty()) {
            Token t = (Token)bigList.remove(0);
            String text = t.getText();
            if (!listOfPositions.containsKey(text)) {
                listOfPositions.put(text, new ArrayList(1));
            }
            ArrayList al = (ArrayList)listOfPositions.get(text);
            SourceCodeLocation loc = new SourceCodeLocation(t.getLine(), t.getPos(), text.length());
            al.add(loc);
        }
        return listOfPositions;
    }

    protected Map step3(Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry elem = it.next();
            List l = (List)elem.getValue();
            if (l.size() >= 2) continue;
            it.remove();
        }
        return map;
    }

    protected void step4(final IFile file, final Map listOfPositions, final String MESSAGE) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Iterator it = listOfPositions.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry elem = it.next();
                    String s = (String)elem.getKey();
                    List l = (List)elem.getValue();
                    String msg = MessageFormat.format(MESSAGE, s);
                    Iterator iter = l.iterator();
                    while (iter.hasNext()) {
                        ISourceCodeLocation loc = (ISourceCodeLocation)iter.next();
                        IMarker m = MagicXYZChecker.access$0(file, loc, msg);
                        MagicXYZChecker.this.createResolution(m);
                    }
                }
            }
        };
        MagicXYZChecker.runMarkerUpdate(runnable);
    }

    protected void createResolution(IMarker marker) {
        AutomatedNAVStyleWarningResolution res = new AutomatedNAVStyleWarningResolution(marker){

            public String getDescription() {
                return "<p><b>Explanation:</b></p><p>Using a literal expression multiple times means that it has some 'magic' purpose.</p><p>Usually such an expression is a constant value, which does not change frequently, but if you ever do want to change the value, it can become very tedious, depending on how often it was used.</p><p>You should try to reuse your code by declaring global constants using the <b>const</b> keyword. This makes your code much more readable and easier to understand.</p><p><b>Note:</b> the numbers -1, 0, 1 and 2 are usually allowed to appear frequently.</p>";
            }
        };
        if (this.fResolutionMap == null) {
            this.fResolutionMap = new HashMap();
        }
        this.fResolutionMap.put(marker, new StyleWarningResolution[]{res});
    }

    static /* synthetic */ IMarker access$0(IFile iFile, ISourceCodeLocation iSourceCodeLocation, String string) throws CoreException {
        return AbstractStyleChecker.createKenyaStyleMarker(iFile, iSourceCodeLocation, string);
    }
}

