/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checks.metrics;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kenya.eclipse.ast.AdvancedPositionFinder;
import kenya.eclipse.style.AutomatedNAVStyleWarningResolution;
import kenya.eclipse.style.StyleWarningResolution;
import kenya.eclipse.style.checkerimpl.AbstractStyleChecker;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import minijava.node.AFuncDecDeclaration;
import minijava.node.Node;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class MethodLengthChecker
extends AbstractStyleChecker {
    public static final String MESSAGE = "This method has a length of {0} lines.\nMaybe you can find a way to split it into smaller (re-usable) parts?";
    private static final String lengthKey = "length";
    private int fMaxLength = Integer.MAX_VALUE;

    public void configure(Map customAttributes) {
        String ln = (String)customAttributes.get(lengthKey);
        if (ln != null) {
            try {
                int length = Integer.parseInt(ln);
                this.fMaxLength = length + 1;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void performCheck(ICheckedCode code, final IFile file) {
        IDocument doc = MethodLengthChecker.getDocument(file);
        IFunction[] funs = code.getFunctions();
        HashMap<ISourceCodeLocation, Integer> lengths = new HashMap<ISourceCodeLocation, Integer>(funs.length / 2);
        int i = 0;
        while (i < funs.length) {
            IFunction function = funs[i];
            AFuncDecDeclaration decl = function.getDeclarationNode();
            ISourceCodeLocation loc = AdvancedPositionFinder.getFullLocation((Node)decl.getIdentifier(), doc);
            Position pos = MethodLengthChecker.calculatePosition(loc, doc);
            int firstOffset = pos.getOffset();
            int lastOffset = firstOffset + pos.getLength();
            try {
                int firstLine = doc.getLineOfOffset(firstOffset);
                int lastLine = doc.getLineOfOffset(lastOffset);
                int lines = lastLine - firstLine;
                if (lines > this.fMaxLength) {
                    lengths.put(loc, new Integer(lines));
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            ++i;
        }
        final Set offences = lengths.entrySet();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Iterator it = offences.iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    ISourceCodeLocation loc = (ISourceCodeLocation)entry.getKey();
                    Integer length = (Integer)entry.getValue();
                    String msg = MessageFormat.format(MethodLengthChecker.MESSAGE, length);
                    IMarker m = MethodLengthChecker.access$0(file, loc, msg);
                    MethodLengthChecker.this.createResolution(m);
                }
            }
        };
        MethodLengthChecker.runMarkerUpdate(runnable);
    }

    protected void createResolution(IMarker marker) {
        AutomatedNAVStyleWarningResolution res = new AutomatedNAVStyleWarningResolution(marker){

            public String getDescription() {
                return "<p><b>Explanation:</b></p><p>The method in question is quite long. Sometimes this is unavoidable, however you should try to keep methods as short as possible and let them do as little as possible. This ensures that you have many small reusable components rather than repeated blocks of code. It is also hard to debug code if methods perform tasks that are not really in their scope or not implied by their name and documentation.</p>";
            }
        };
        if (this.fResolutionMap == null) {
            this.fResolutionMap = new HashMap();
        }
        this.fResolutionMap.put(marker, new StyleWarningResolution[]{res});
    }

    static /* synthetic */ IMarker access$0(IFile iFile, ISourceCodeLocation iSourceCodeLocation, String string) throws CoreException {
        return AbstractStyleChecker.createKenyaStyleMarker(iFile, iSourceCodeLocation, string);
    }
}

