/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checks.metrics;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kenya.eclipse.ast.AdvancedPositionFinder;
import kenya.eclipse.style.AutomatedNAVStyleWarningResolution;
import kenya.eclipse.style.StyleWarningResolution;
import kenya.eclipse.style.checkerimpl.AbstractStyleChecker;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import minijava.node.AFormalParamList;
import minijava.node.AFuncDecDeclaration;
import minijava.node.Node;
import minijava.node.PTypeName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;

public class ParameterLengthChecker
extends AbstractStyleChecker {
    public static final String MESSAGE = "This method takes {0} parameters. \nTry splitting the method into smaller functional parts or creating\na class to group closely related parameters.";
    private static final String lengthKey = "length";
    private int fMaxLength = Integer.MAX_VALUE;

    public void configure(Map customAttributes) {
        String ln = (String)customAttributes.get(lengthKey);
        if (ln != null) {
            try {
                int length;
                this.fMaxLength = length = Integer.parseInt(ln);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void performCheck(ICheckedCode code, final IFile file) {
        IDocument doc = ParameterLengthChecker.getDocument(file);
        IFunction[] funs = code.getFunctions();
        HashMap<ISourceCodeLocation, Integer> lengths = new HashMap<ISourceCodeLocation, Integer>();
        int i = 0;
        while (i < funs.length) {
            IFunction function = funs[i];
            AFuncDecDeclaration decl = function.getDeclarationNode();
            AFormalParamList paramlist = (AFormalParamList)decl.getFormalParamList();
            if (paramlist != null) {
                int length;
                PTypeName n = paramlist.getTypeName();
                LinkedList list = paramlist.getCommaTypeName();
                int n2 = n == null ? 0 : (length = 1 + (list == null ? 0 : list.size()));
                if (length > this.fMaxLength) {
                    ISourceCodeLocation loc = AdvancedPositionFinder.getFullLocation((Node)paramlist, doc);
                    lengths.put(loc, new Integer(length));
                }
            }
            ++i;
        }
        final Set offences = lengths.entrySet();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Iterator it = offences.iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    ISourceCodeLocation loc = (ISourceCodeLocation)entry.getKey();
                    Integer length = (Integer)entry.getValue();
                    String msg = MessageFormat.format(ParameterLengthChecker.MESSAGE, length);
                    IMarker m = ParameterLengthChecker.access$0(file, loc, msg);
                    ParameterLengthChecker.this.createResolution(m);
                }
            }
        };
        ParameterLengthChecker.runMarkerUpdate(runnable);
    }

    protected void createResolution(IMarker marker) {
        AutomatedNAVStyleWarningResolution res = new AutomatedNAVStyleWarningResolution(marker){

            public String getDescription() {
                return "<p><b>Explanation:</b></p><p>The method in question takes many parameters. Sometimes this is unavoidable, however you should try to keep methods as short as possible and let them do as little as possible. This ensures that you have many small reusable components rather than repeated blocks of code, which also makes debugging much easier.</p><p>If you find that you are often using the same group of variables together, then you should consider creating a class which contains logically related variables.</p>";
            }
        };
        if (this.fResolutionMap == null) {
            this.fResolutionMap = new HashMap();
        }
        this.fResolutionMap.put(marker, new StyleWarningResolution[]{res});
    }

    static /* synthetic */ IMarker access$0(IFile iFile, ISourceCodeLocation iSourceCodeLocation, String string) throws CoreException {
        return AbstractStyleChecker.createKenyaStyleMarker(iFile, iSourceCodeLocation, string);
    }
}

