/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checks.scope;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kenya.eclipse.ast.NodeTools;
import kenya.eclipse.ast.OccurrencesFinder;
import kenya.eclipse.ast.SimpleASTProvider;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentModificationOperation;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentTextOperation;
import kenya.eclipse.multieditor.kenya.util.LocationUtils;
import kenya.eclipse.style.StyleWarningResolution;
import kenya.eclipse.style.checkerimpl.AbstractStyleChecker;
import kenya.eclipse.style.checks.scope.Validator;
import kenya.eclipse.style.checks.scope.VariableDeclarationSearch;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.IVariable;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import mediator.ICheckedCode;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.AVarDecInnerDeclaration;
import minijava.node.Node;
import minijava.node.Start;
import minijava.node.Switch;
import minijava.node.TIdentifier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class ShadowedConstantsChecker
extends AbstractStyleChecker {
    public static final String MESSAGE = "<p><b>Explanation:</b></p><p>You have declared a local variable with the same name as a constant.<br>This is called &quot;Shadowing&quot; and means that the constant will not be accessible inside this method, since the <i>local</i> scope has precedence over the <i>global</i> one.<br>Although it is possible in Java to still reference the constant, it is generally advisable to avoid this situation altogether. The easiest way is to simply rename the local variable.<br>This fix will ask you for a new name and perform the rename for you.</p>";

    public void configure(Map customAttributes) {
    }

    public void performCheck(final ICheckedCode code, final IFile file) {
        IVariable[] constants = code.getConstants();
        if (constants.length == 0) {
            return;
        }
        Object[] constantNames = new String[constants.length];
        int i = 0;
        while (i < constants.length) {
            constantNames[i] = constants[i].getName();
            ++i;
        }
        Arrays.sort(constantNames);
        final ArrayList<Object> offendingLocations = new ArrayList<Object>(constantNames.length);
        IFunction[] funs = code.getFunctions();
        int i2 = 0;
        while (i2 < funs.length) {
            String name;
            TIdentifier id;
            AArrayDecInnerDeclaration a;
            IFunction fun = funs[i2];
            IVariable[] params = fun.getArguments();
            int j = 0;
            while (j < params.length) {
                IVariable param = params[j];
                if (Arrays.binarySearch(constantNames, param.getName()) >= 0) {
                    ISourceCodeLocation loc = param.getPosition();
                    IClass c = param.getType();
                    SourceCodeLocation newloc = new SourceCodeLocation(loc.getLineNumber(), loc.getColumnNumber() + c.getName().length() + 1, param.getName().length());
                    offendingLocations.add(newloc);
                }
                ++j;
            }
            VariableDeclarationSearch vds = new VariableDeclarationSearch();
            fun.getDeclarationNode().getBlock().apply((Switch)vds);
            List arrays = vds.getArrays();
            List vars = vds.getVars();
            Iterator it = arrays.iterator();
            while (it.hasNext()) {
                a = (AArrayDecInnerDeclaration)it.next();
                id = a.getIdentifier();
                name = id.getText();
                if (Arrays.binarySearch(constantNames, name) < 0) continue;
                offendingLocations.add(NodeTools.getLocation((Node)id));
            }
            it = vars.iterator();
            while (it.hasNext()) {
                a = (AVarDecInnerDeclaration)it.next();
                id = a.getIdentifier();
                name = id.getText();
                if (Arrays.binarySearch(constantNames, name) < 0) continue;
                offendingLocations.add(NodeTools.getLocation((Node)id));
            }
            ++i2;
        }
        IWorkspaceRunnable run = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IDocument doc = ShadowedConstantsChecker.access$0(file);
                ShadowedConstantsChecker.this.fResolutionMap = new HashMap(offendingLocations.size());
                HashMap<String, String> inputs = new HashMap<String, String>(1);
                String key = "Please enter new variable name.";
                String var = "newName";
                inputs.put(key, var);
                HashMap<String, Validator> valid = new HashMap<String, Validator>(1);
                valid.put(var, new Validator());
                Iterator it = offendingLocations.iterator();
                while (it.hasNext()) {
                    ISourceCodeLocation loc = (ISourceCodeLocation)it.next();
                    IMarker m = ShadowedConstantsChecker.access$2(file, loc, "This local variable is 'shadowing' a constant.");
                    DocumentModificationOperation dmo = new DocumentModificationOperation(inputs, valid);
                    Start ast = SimpleASTProvider.getAST(code);
                    OccurrencesFinder of = new OccurrencesFinder();
                    of.initialize(ast, code, doc, loc);
                    List occs = of.perform();
                    Iterator iter = occs.iterator();
                    while (iter.hasNext()) {
                        TIdentifier tid = (TIdentifier)iter.next();
                        ISourceCodeLocation location = NodeTools.getLocation((Node)tid);
                        Position pos = LocationUtils.convert(location, doc);
                        DocumentTextOperation op = DocumentTextOperation.newTextReplacement(pos.offset, pos.length, "${" + var + "}");
                        dmo.addOperation(op);
                    }
                    StyleWarningResolution res = new StyleWarningResolution(this, "rename local variable", m, dmo){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public String getDescription() {
                            return "<p><b>Explanation:</b></p><p>You have declared a local variable with the same name as a constant.<br>This is called &quot;Shadowing&quot; and means that the constant will not be accessible inside this method, since the <i>local</i> scope has precedence over the <i>global</i> one.<br>Although it is possible in Java to still reference the constant, it is generally advisable to avoid this situation altogether. The easiest way is to simply rename the local variable.<br>This fix will ask you for a new name and perform the rename for you.</p>";
                        }
                    };
                    ShadowedConstantsChecker.this.fResolutionMap.put(m, res);
                }
            }
        };
        AbstractStyleChecker.runMarkerUpdate(run);
    }

    static /* synthetic */ IDocument access$0(IFile iFile) {
        return AbstractStyleChecker.getDocument(iFile);
    }

    static /* synthetic */ IMarker access$2(IFile iFile, ISourceCodeLocation iSourceCodeLocation, String string) throws CoreException {
        return AbstractStyleChecker.createKenyaStyleMarker(iFile, iSourceCodeLocation, string);
    }
}

