/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checks.swit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import kenya.eclipse.KenyaConstants;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentModificationOperation;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentTextOperation;
import kenya.eclipse.style.StyleWarningResolution;
import kenya.eclipse.style.checkerimpl.AbstractStyleChecker;
import kenya.eclipse.style.checks.swit.BreakSearch;
import kenya.eclipse.style.checks.swit.FallThroughCommentSearch;
import kenya.eclipse.style.checks.swit.SwitchSearch;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import mediator.ICheckedCode;
import minijava.node.ABlock;
import minijava.node.ACasePossibleCase;
import minijava.node.ADefaultPossibleCase;
import minijava.node.ASwitchBlock;
import minijava.node.ASwitchStatement;
import minijava.node.Node;
import minijava.node.PPossibleCase;
import minijava.node.TDefault;
import minijava.node.TRBrace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class BreakOmissionChecker
extends AbstractStyleChecker {
    private static final String MESSAGE = "This case does not have a break; statement. What may happen is that cases 'fall through'.";
    public static final int CREATE_BREAK_STATEMENT = 0;
    public static final int CREATE_FALL_THROUGH_COMMENT = 1;
    protected IMarker m;

    protected static Position calculatePosition(ISourceCodeLocation loc, IDocument doc) {
        return AbstractStyleChecker.calculatePosition(loc, doc);
    }

    public void configure(Map customAttributes) {
    }

    public void performCheck(ICheckedCode code, final IFile file) {
        IFunction[] functions = code.getFunctions();
        ArrayList bigList = new ArrayList(1);
        int i = 0;
        while (i < functions.length) {
            Node node = (Node)functions[i].getDeclarationNode().clone();
            bigList.addAll(SwitchSearch.getSwitchStatements(node));
            ++i;
        }
        final ArrayList<PPossibleCase> caseList = new ArrayList<PPossibleCase>(bigList.size() * 2);
        Iterator it = bigList.iterator();
        while (it.hasNext()) {
            ASwitchStatement s = (ASwitchStatement)it.next();
            ASwitchBlock block = (ASwitchBlock)s.getSwitchBlock();
            LinkedList cases = block.getPossibleCase();
            ListIterator iter = cases.listIterator();
            while (iter.hasNext()) {
                PPossibleCase element = (PPossibleCase)iter.next();
                if (BreakSearch.containsBreak(element) || FallThroughCommentSearch.containsFallThroughComment(element, BreakOmissionChecker.getDocument(file))) continue;
                caseList.add(element);
            }
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Iterator it = caseList.iterator();
                while (it.hasNext()) {
                    ABlock caseBlock;
                    TDefault t;
                    ADefaultPossibleCase c;
                    Object o = it.next();
                    if (o instanceof ADefaultPossibleCase) {
                        c = (ADefaultPossibleCase)o;
                        t = c.getDefault();
                        caseBlock = (ABlock)c.getBlock();
                    } else {
                        if (!(o instanceof ACasePossibleCase)) continue;
                        c = (ACasePossibleCase)o;
                        t = c.getCase();
                        caseBlock = (ABlock)c.getBlock();
                    }
                    SourceCodeLocation loc = new SourceCodeLocation(t.getLine(), t.getPos(), t.getText().length());
                    BreakOmissionChecker.this.m = BreakOmissionChecker.access$1(file, (ISourceCodeLocation)loc, BreakOmissionChecker.MESSAGE);
                    TRBrace brace = caseBlock.getRBrace();
                    int line = brace.getLine() - 1;
                    int fixOffset = -1;
                    try {
                        fixOffset = BreakOmissionChecker.access$0(file).getLineOffset(line) + brace.getPos() - 1;
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                    BreakOmissionChecker.this.m.setAttribute("__fix_offset", fixOffset);
                    BreakOmissionMarkerResolution r0 = new BreakOmissionMarkerResolution(BreakOmissionChecker.this.m, 0);
                    BreakOmissionMarkerResolution r1 = new BreakOmissionMarkerResolution(BreakOmissionChecker.this.m, 1);
                    if (BreakOmissionChecker.this.fResolutionMap == null) {
                        BreakOmissionChecker.this.fResolutionMap = new HashMap(caseList.size());
                    }
                    BreakOmissionChecker.this.fResolutionMap.put(BreakOmissionChecker.this.m, new StyleWarningResolution[]{r0, r1});
                }
            }
        };
        BreakOmissionChecker.runMarkerUpdate(runnable);
    }

    static /* synthetic */ IDocument access$0(IFile iFile) {
        return AbstractStyleChecker.getDocument(iFile);
    }

    static /* synthetic */ IMarker access$1(IFile iFile, ISourceCodeLocation iSourceCodeLocation, String string) throws CoreException {
        return AbstractStyleChecker.createKenyaStyleMarker(iFile, iSourceCodeLocation, string);
    }

    class BreakOmissionMarkerResolution
    extends StyleWarningResolution {
        public BreakOmissionMarkerResolution(IMarker marker, int type) {
            super(null, marker, new DocumentModificationOperation());
            this.initLabel(type);
            this.initDescription(type);
            this.init(marker, type);
        }

        private void initDescription(int type) {
            switch (type) {
                case 0: {
                    this.fDescription = "<p><b>Explanation:</b></p><p>A <b>break statement</b> marks the end of a 'case' in a switch block. This prevents cases from falling through, which means that the <b>next</b> case is <b>also</b> executed.</p><p><b>Note:</b> If the case is intended to fall through, you should create a <em>fall-through comment</em> instead.</p>";
                    break;
                }
                case 1: {
                    this.fDescription = "<p><b>Explanation:</b></p><p>An <b>explicit fall-through comment</b> helps to distinguish accidental fall-through situations from ones that were created on purpose.<br>In larger software projects it is important to signal the intentions behind code in case another person works on the same bit of code so as to prevent mistakes.</p><p><b>Note:</b> If the case should not fall through, you should create a <i>break statement</i> instead.</p>";
                    break;
                }
                default: {
                    this.fDescription = "Something went wrong when creating the automatic solution, so just ignore this warning. If this error persists, contact a qualified helper.";
                }
            }
        }

        private void initLabel(int type) {
            switch (type) {
                case 0: {
                    this.fLabel = "Create break statement";
                    break;
                }
                case 1: {
                    this.fLabel = "Create fall-through comment";
                    break;
                }
                default: {
                    this.fLabel = "invalid operation, see description..";
                }
            }
        }

        private void init(IMarker marker, int type) {
            String postfix;
            String prefix;
            IDocument doc = BreakOmissionChecker.access$0((IFile)marker.getResource());
            if (doc == null) {
                return;
            }
            int offset = marker.getAttribute("__fix_offset", -1);
            if (offset < 0) {
                return;
            }
            try {
                int line = doc.getLineOfOffset(offset);
                String delim = doc.getLineDelimiter(line);
                int lineOffset = doc.getLineOffset(line);
                int length = offset - lineOffset;
                String lineContent = doc.get(lineOffset, length);
                if ("".equals(lineContent.trim())) {
                    String indent = lineContent;
                    if (indent.charAt(0) == '\t') {
                        prefix = "\t";
                    } else {
                        prefix = "";
                        int i = 0;
                        while (i < KenyaConstants.EDITOR_TAB_WIDTH) {
                            prefix = String.valueOf(prefix) + ' ';
                            ++i;
                        }
                    }
                    if (type == 1) {
                        prefix = String.valueOf(prefix) + "//";
                    }
                    postfix = String.valueOf(delim) + indent;
                } else if (type == 1) {
                    prefix = " /*";
                    postfix = "*/ ";
                } else {
                    prefix = " ";
                    postfix = " ";
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            String insertion = String.valueOf(prefix) + this.getGeneration(type) + postfix;
            this.fOperation.addOperation(DocumentTextOperation.newTextInsertion(offset, insertion));
        }

        private String getGeneration(int type) {
            switch (type) {
                case 0: {
                    return "break;";
                }
                case 1: {
                    return "fall through";
                }
            }
            return "";
        }
    }
}

