/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.checks.swit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import kenya.eclipse.KenyaConstants;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentTextOperation;
import kenya.eclipse.style.StyleWarningResolution;
import kenya.eclipse.style.checkerimpl.AbstractStyleChecker;
import kenya.eclipse.style.checks.swit.SwitchSearch;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import mediator.ICheckedCode;
import minijava.node.ADefaultPossibleCase;
import minijava.node.ASwitchBlock;
import minijava.node.ASwitchStatement;
import minijava.node.Node;
import minijava.node.PPossibleCase;
import minijava.node.TRBrace;
import minijava.node.TSwitch;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DefaultOmissionChecker
extends AbstractStyleChecker {
    private static final String MESSAGE = "This switch statement does not have a default case. Consider what happens if none of your other cases match...";

    public void configure(Map customAttributes) {
    }

    public void performCheck(ICheckedCode code, final IFile file) {
        IFunction[] functions = code.getFunctions();
        final ArrayList bigList = new ArrayList(1);
        int i = 0;
        while (i < functions.length) {
            Node node = (Node)functions[i].getDeclarationNode().clone();
            bigList.addAll(SwitchSearch.getSwitchStatements(node));
            ++i;
        }
        Iterator it = bigList.iterator();
        block1: while (it.hasNext()) {
            ASwitchStatement s = (ASwitchStatement)it.next();
            ASwitchBlock block = (ASwitchBlock)s.getSwitchBlock();
            LinkedList cases = block.getPossibleCase();
            ListIterator iter = cases.listIterator();
            while (iter.hasNext()) {
                PPossibleCase element = (PPossibleCase)iter.next();
                if (!(element instanceof ADefaultPossibleCase)) continue;
                it.remove();
                continue block1;
            }
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Iterator it = bigList.iterator();
                while (it.hasNext()) {
                    ASwitchStatement s = (ASwitchStatement)it.next();
                    TSwitch sw = s.getSwitch();
                    SourceCodeLocation loc = new SourceCodeLocation(sw.getLine(), sw.getPos(), sw.getText().length());
                    IMarker m = DefaultOmissionChecker.access$1(file, (ISourceCodeLocation)loc, DefaultOmissionChecker.MESSAGE);
                    TRBrace brace = ((ASwitchBlock)s.getSwitchBlock()).getRBrace();
                    int line = brace.getLine() - 1;
                    int fixOffset = -1;
                    try {
                        fixOffset = DefaultOmissionChecker.access$0(file).getLineOffset(line) + brace.getPos() - 1;
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                    m.setAttribute("__fix_offset", fixOffset);
                    DefaultOmissionMarkerResolution r0 = new DefaultOmissionMarkerResolution(m);
                    if (DefaultOmissionChecker.this.fResolutionMap == null) {
                        DefaultOmissionChecker.this.fResolutionMap = new HashMap(bigList.size());
                    }
                    DefaultOmissionChecker.this.fResolutionMap.put(m, new StyleWarningResolution[]{r0});
                }
            }
        };
        DefaultOmissionChecker.runMarkerUpdate(runnable);
    }

    static /* synthetic */ IDocument access$0(IFile iFile) {
        return AbstractStyleChecker.getDocument(iFile);
    }

    static /* synthetic */ IMarker access$1(IFile iFile, ISourceCodeLocation iSourceCodeLocation, String string) throws CoreException {
        return AbstractStyleChecker.createKenyaStyleMarker(iFile, iSourceCodeLocation, string);
    }

    class DefaultOmissionMarkerResolution
    extends StyleWarningResolution {
        public DefaultOmissionMarkerResolution(IMarker marker) {
            super("Create default case", marker);
            this.init(marker);
        }

        public String getDescription() {
            return "<p><b>Explanation:</b></p><p>You have missed out the <b>default case</b> in a switch. It is duly possible that during the execution of your code, none of the other cases match. That event is handled by the 'default' case.<br>If it does not exist, the switch will simply return, the program continues executing and you may have no idea what has happened.<br>That's why it is a good idea to always have a default case, so that you can inform the user (or yourself) that no other case was satisfied.</p><p>Applying this fix will create a default case in the switch block.</p>";
        }

        private void init(IMarker marker) {
            IDocument doc = DefaultOmissionChecker.access$0((IFile)marker.getResource());
            if (doc == null) {
                return;
            }
            int offset = marker.getAttribute("__fix_offset", -1);
            if (offset < 0) {
                return;
            }
            String indentUnit = "";
            StringBuffer buf = new StringBuffer();
            try {
                String postfix;
                String prefix;
                String lineContent;
                int line = doc.getLineOfOffset(offset);
                String delim = doc.getLineDelimiter(line);
                int lineOffset = doc.getLineOffset(line);
                int length = offset - lineOffset;
                String indent = lineContent = doc.get(lineOffset, length);
                if (indent.charAt(0) == '\t') {
                    indentUnit = "\t";
                } else {
                    indentUnit = "";
                    int i = 0;
                    while (i < KenyaConstants.EDITOR_TAB_WIDTH) {
                        indentUnit = String.valueOf(indentUnit) + ' ';
                        ++i;
                    }
                }
                if ("".equals(lineContent.trim())) {
                    prefix = indentUnit;
                    postfix = String.valueOf(delim) + indent;
                } else {
                    int nonWhiteLength = lineContent.trim().length();
                    int whiteEnd = lineContent.length() - nonWhiteLength;
                    indent = indent.substring(0, whiteEnd);
                    prefix = String.valueOf(delim) + indent;
                    postfix = String.valueOf(delim) + indent;
                    postfix = postfix.substring(0, postfix.length() - indentUnit.length());
                }
                buf.append(prefix).append("default: {").append(delim);
                buf.append(indent).append(indentUnit).append(indentUnit).append("//TODO: fill default case").append(delim);
                buf.append(indent).append(indentUnit).append(indentUnit).append("break;").append(delim);
                buf.append(indent).append(indentUnit).append("}").append(postfix);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            this.fOperation.addOperation(DocumentTextOperation.newTextInsertion(offset, buf.toString()));
        }
    }
}

