/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kenya.eclipse.style.KenyaStyleConstants;
import kenya.eclipse.style.KenyaStyleManager;
import kenya.eclipse.style.StyleCheckRegistry;
import kenya.eclipse.style.checkerimpl.IStyleChecker;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class PropertyUtils {
    public static final String ENABLED = KenyaStyleConstants.ENABLED;
    public static final String DISABLED = KenyaStyleConstants.DISABLED;

    public static List getFilteredEnabledStyleChecks(IFile file, String filter, boolean setDefaults) {
        StyleCheckRegistry reg = KenyaStyleManager.getStyleCheckRegistry();
        Collection ids = reg.listIds();
        ArrayList<IStyleChecker> al = new ArrayList<IStyleChecker>();
        if (filter != ENABLED && filter != DISABLED) {
            return al;
        }
        try {
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                QualifiedName id = (QualifiedName)it.next();
                String val = file.getPersistentProperty(id);
                if (val == null && setDefaults) {
                    val = reg.getStyleChecker(id).getDescriptor().isDefaultEnabled() ? ENABLED : DISABLED;
                    file.setPersistentProperty(id, val);
                }
                if (!filter.equals(val)) continue;
                al.add(reg.getStyleChecker(id));
            }
        }
        catch (CoreException coreException) {}
        return al;
    }

    public static boolean isStyleCheckingEnabled(IFile file, boolean setDefaults) {
        try {
            String s = file.getPersistentProperty(KenyaStyleConstants.PROP_STYLE_CHECKING_ENABLED);
            if (s == null && setDefaults) {
                s = ENABLED;
                file.setPersistentProperty(KenyaStyleConstants.PROP_STYLE_CHECKING_ENABLED, s);
            }
            return ENABLED.equals(s);
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

