/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.style.properties;

import kenya.eclipse.style.KenyaStyleConstants;
import kenya.eclipse.style.KenyaStyleManager;
import kenya.eclipse.style.StyleCheckRegistry;
import kenya.eclipse.style.checkerimpl.IStyleChecker;
import kenya.eclipse.style.properties.PropertyUtils;
import kenya.eclipse.style.ui.StyleCheckListContentProvider;
import kenya.eclipse.style.ui.StyleCheckerLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class StylePropertyPage
extends PropertyPage {
    private static final String ENABLE_STYLE = "Enable Style Checking";
    private static final String DOES_NOT_APPLY_TO_THIS_RESOURCE = "This page does not apply to this resource since it is not contained in a Kenya project.";
    private static final String CHOOSE_CHECKS_DISABLE_ENABLE = "Choose individual checks to enable or disable...";
    private Button enabledBox;
    private CheckboxTableViewer fCheckViewer;
    private StyleCheckListContentProvider fContentProvider = new StyleCheckListContentProvider();
    private StyleCheckerLabelProvider fLabelProvider = new StyleCheckerLabelProvider();
    private boolean previousEnabledValue;
    private Object[] previousEnabledChecks;

    private void addFirstSection(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        this.createEnabledButton(composite);
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addSecondSection(Composite parent) {
        StyleCheckRegistry reg = KenyaStyleManager.getStyleCheckRegistry();
        Composite c = this.createComposite(parent, 1);
        Label name = new Label(c, 0);
        name.setText(CHOOSE_CHECKS_DISABLE_ENABLE);
        GridData data = new GridData(1808);
        data.heightHint = 10;
        this.fCheckViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.fCheckViewer.getTable().setLayoutData((Object)data);
        this.fCheckViewer.getTable().setFont(parent.getFont());
        this.fCheckViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fCheckViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fCheckViewer.setInput((Object)reg);
        this.fCheckViewer.getTable().setEnabled(this.enabledBox != null && this.enabledBox.getSelection());
        ViewerSorter v = new ViewerSorter();
        this.fCheckViewer.setSorter(v);
        this.previousEnabledChecks = PropertyUtils.getFilteredEnabledStyleChecks(this.getFile(), PropertyUtils.ENABLED, true).toArray(new IStyleChecker[0]);
        this.fCheckViewer.setCheckedElements(this.previousEnabledChecks);
    }

    private void createEnabledButton(Composite composite) {
        this.enabledBox = new Button(composite, 131104);
        this.enabledBox.setAlignment(16384);
        this.enabledBox.setText(ENABLE_STYLE);
        this.enabledBox.setSelection(this.previousEnabledValue);
        this.enabledBox.setFont(composite.getFont());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.enabledBox.setLayoutData((Object)data);
        this.enabledBox.addSelectionListener((SelectionListener)new CheckHandler());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        IFile f = this.getFile();
        try {
            if (!f.getProject().hasNature("kenya.eclipse.kenyanature")) {
                Composite c = this.createComposite(composite, 1);
                Label notApply = new Label(c, 0);
                notApply.setText(DOES_NOT_APPLY_TO_THIS_RESOURCE);
                return composite;
            }
        }
        catch (CoreException coreException) {}
        try {
            String enabled = f.getPersistentProperty(KenyaStyleConstants.PROP_STYLE_CHECKING_ENABLED);
            this.previousEnabledValue = KenyaStyleConstants.ENABLED.equals(enabled);
        }
        catch (CoreException coreException) {}
        this.addFirstSection(composite);
        this.addSeparator(composite);
        this.addSecondSection(composite);
        return composite;
    }

    private Composite createComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
        this.enabledBox.setSelection(true);
        int no = this.fCheckViewer.getTable().getItemCount();
        int i = 0;
        while (i < no) {
            IStyleChecker o = (IStyleChecker)this.fCheckViewer.getElementAt(i);
            this.fCheckViewer.setChecked((Object)o, o.getDescriptor().isDefaultEnabled());
            ++i;
        }
    }

    public boolean performOk() {
        try {
            IFile f = this.getFile();
            f.setPersistentProperty(KenyaStyleConstants.PROP_STYLE_CHECKING_ENABLED, this.enabledBox.getSelection() ? KenyaStyleConstants.ENABLED : KenyaStyleConstants.DISABLED);
            int i = 0;
            while (i < this.fCheckViewer.getTable().getItemCount()) {
                IStyleChecker c = (IStyleChecker)this.fCheckViewer.getElementAt(i);
                QualifiedName n = c.getDescriptor().getID();
                String val = this.fCheckViewer.getChecked((Object)c) ? KenyaStyleConstants.ENABLED : KenyaStyleConstants.DISABLED;
                f.setPersistentProperty(n, val);
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    private IFile getFile() {
        return (IFile)this.getElement();
    }

    private class CheckHandler
    implements SelectionListener {
        CheckHandler() {
        }

        public void widgetSelected(SelectionEvent event) {
            StylePropertyPage.this.fCheckViewer.getTable().setEnabled(StylePropertyPage.this.enabledBox.getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

