/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import kenya.eclipse.KenyaPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class KenyaImages {
    private static final String NAME_PREFIX = "kenya.eclipse.";
    private static final int NAME_PREFIX_LENGTH = "kenya.eclipse.".length();
    private static final String ICON_PATH_PREFIX = "icons/full/";
    private static URL fgIconBaseURL = null;
    private static final String BANNER = "wizban/";
    private static final String DLCL = "dlcl16";
    private static final String ELCL = "elcl16";
    private static final String OBJECT = "obj16/";
    private static final String OVR = "ovr16/";
    private static final String ETOOL = "etool16/";
    private static final String VIEW = "eview16/";
    private static ImageRegistry fgImageRegistry;
    private static HashMap fgAvoidSWTErrorMap;
    public static final String IMG_OBJ_K_PROJECT = "kenya.eclipse.k2project_obj.png";
    public static final String IMG_OBJ_K_FILE = "kenya.eclipse.k2cu_obj.png";
    public static final String IMG_OBJ_CLASS = "kenya.eclipse.class_obj.gif";
    public static final String IMG_OBJ_KENYA_APP = "kenya.eclipse.kenya_app.png";
    public static final String IMG_OBJ_FIELD_PUBLIC = "kenya.eclipse.field_public_obj.gif";
    public static final String IMG_OBJ_METH_PUBLIC = "kenya.eclipse.methpub_obj.gif";
    public static final String IMG_OBJ_VAR_LOCAL = "kenya.eclipse.localvariable_obj.gif";
    public static final String IMG_WIZ_NPROJ = "kenya.eclipse.newk2prj_wiz.png";
    public static final String IMG_WIZBAN_NPROJ = "kenya.eclipse.newkprj_wiz.png";
    public static final String IMG_VIEW_VARIABLE_TAB = "kenya.eclipse.variable_tab.gif";
    public static final ImageDescriptor DESC_K_PROJECT;
    public static final ImageDescriptor DESC_K_FILE;
    public static final ImageDescriptor DESC_K_NPROJ_WIZ;
    public static final ImageDescriptor DESC_K_NPROJ_WIZBAN;
    public static final ImageDescriptor DESC_K_OVR;
    public static final ImageDescriptor DESC_ERROR_OVR;
    public static final ImageDescriptor DESC_WARNING_OVR;
    public static final ImageDescriptor DESC_VIEW_VARIABLE_TAB;
    public static final ImageDescriptor DESC_OBJ_KENYA_APP;
    public static final ImageDescriptor DESC_OBJ_CLASS;
    public static final ImageDescriptor DESC_OBJ_FIELD_PUBLIC;
    public static final ImageDescriptor DESC_OBJ_METH_PUBLIC;
    public static final ImageDescriptor DESC_OBJ_VAR_LOCAL;
    public static final ImageDescriptor DESC_ELCL_CODE_ASSIST;
    public static final ImageDescriptor DESC_DLCL_CODE_ASSIST;

    static {
        String pathSuffix = ICON_PATH_PREFIX;
        fgIconBaseURL = KenyaPlugin.getDefault().getBundle().getEntry(pathSuffix);
        fgImageRegistry = null;
        fgAvoidSWTErrorMap = null;
        DESC_K_PROJECT = KenyaImages.createManaged(OBJECT, IMG_OBJ_K_PROJECT);
        DESC_K_FILE = KenyaImages.createManaged(OBJECT, IMG_OBJ_K_FILE);
        DESC_K_NPROJ_WIZ = KenyaImages.createManaged(ETOOL, IMG_WIZ_NPROJ);
        DESC_K_NPROJ_WIZBAN = KenyaImages.createManaged(BANNER, IMG_WIZBAN_NPROJ);
        DESC_K_OVR = KenyaImages.create(OVR, "K2_ovr.png");
        DESC_ERROR_OVR = KenyaImages.create(OVR, "error_co.gif");
        DESC_WARNING_OVR = KenyaImages.create(OVR, "warning_co.gif");
        DESC_VIEW_VARIABLE_TAB = KenyaImages.createManaged(VIEW, IMG_VIEW_VARIABLE_TAB);
        DESC_OBJ_KENYA_APP = KenyaImages.createManaged(OBJECT, IMG_OBJ_KENYA_APP);
        DESC_OBJ_CLASS = KenyaImages.createManaged(OBJECT, IMG_OBJ_CLASS);
        DESC_OBJ_FIELD_PUBLIC = KenyaImages.createManaged(OBJECT, IMG_OBJ_FIELD_PUBLIC);
        DESC_OBJ_METH_PUBLIC = KenyaImages.createManaged(OBJECT, IMG_OBJ_METH_PUBLIC);
        DESC_OBJ_VAR_LOCAL = KenyaImages.createManaged(OBJECT, IMG_OBJ_VAR_LOCAL);
        DESC_ELCL_CODE_ASSIST = KenyaImages.create(ELCL, "metharg_obj.gif");
        DESC_DLCL_CODE_ASSIST = KenyaImages.create(DLCL, "metharg_obj.gif");
    }

    private KenyaImages() {
    }

    public static Image getImage(String key) {
        return KenyaImages.getImageRegistry().get(key);
    }

    static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            Iterator iter = fgAvoidSWTErrorMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                fgImageRegistry.put(key, (ImageDescriptor)fgAvoidSWTErrorMap.get(key));
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        KenyaImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        KenyaImages.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)KenyaImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        ImageDescriptor descriptor = KenyaImages.create("e" + type, relPath);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)KenyaImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (fgAvoidSWTErrorMap == null) {
                fgAvoidSWTErrorMap = new HashMap();
            }
            fgAvoidSWTErrorMap.put(name, result);
            if (fgImageRegistry != null) {
                KenyaPlugin.log("Internal Error: Image registry already defined");
            }
            return result;
        }
        catch (MalformedURLException e) {
            KenyaPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)KenyaImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            KenyaPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append(name);
        return new URL(fgIconBaseURL, buffer.toString());
    }
}

