/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ui;

import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.ui.KenyaImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;

public class KenyaLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        IFile file;
        if (element instanceof IProject) {
            IProject proj = (IProject)element;
            if (!proj.isAccessible()) {
                return;
            }
            try {
                if (proj.hasNature("kenya.eclipse.kenyanature")) {
                    decoration.addOverlay(KenyaImages.DESC_K_OVR);
                }
            }
            catch (CoreException e) {
                KenyaPlugin.log(e);
            }
        } else if (element instanceof IFile && "k".equals((file = (IFile)element).getFileExtension())) {
            int severity = KenyaLabelDecorator.calculateMaxMarkerSeverity(file);
            switch (severity) {
                case 1: {
                    decoration.addOverlay(KenyaImages.DESC_WARNING_OVR, 2);
                    return;
                }
                case 2: {
                    decoration.addOverlay(KenyaImages.DESC_ERROR_OVR, 2);
                    return;
                }
            }
        }
    }

    static int calculateMaxMarkerSeverity(IFile file) {
        int severity;
        block7: {
            severity = -1;
            try {
                IMarker[] ms = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                int i = 0;
                while (i < ms.length) {
                    switch (ms[i].getAttribute("severity", severity)) {
                        case 2: {
                            severity = 2;
                            break block7;
                        }
                        case 1: {
                            severity = 1;
                        }
                        default: {
                            ++i;
                        }
                    }
                }
            }
            catch (CoreException e) {
                KenyaPlugin.log(e);
            }
        }
        return severity;
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }
}

