/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ui.actions;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;

public class CompositeActionGroup
extends ActionGroup {
    private ActionGroup[] fGroups;

    public CompositeActionGroup() {
    }

    public CompositeActionGroup(ActionGroup[] groups) {
        this.setGroups(groups);
    }

    protected void setGroups(ActionGroup[] groups) {
        Assert.isTrue((this.fGroups == null ? 1 : 0) != 0);
        Assert.isNotNull((Object)groups);
        this.fGroups = groups;
    }

    public ActionGroup get(int index) {
        if (this.fGroups == null) {
            return null;
        }
        return this.fGroups[index];
    }

    public void addGroup(ActionGroup group) {
        if (this.fGroups == null) {
            this.fGroups = new ActionGroup[]{group};
        } else {
            ActionGroup[] newGroups = new ActionGroup[this.fGroups.length + 1];
            System.arraycopy(this.fGroups, 0, newGroups, 0, this.fGroups.length);
            newGroups[this.fGroups.length] = group;
            this.fGroups = newGroups;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fGroups == null) {
            return;
        }
        int i = 0;
        while (i < this.fGroups.length) {
            this.fGroups[i].dispose();
            ++i;
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (this.fGroups == null) {
            return;
        }
        int i = 0;
        while (i < this.fGroups.length) {
            this.fGroups[i].fillActionBars(actionBars);
            ++i;
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.fGroups == null) {
            return;
        }
        int i = 0;
        while (i < this.fGroups.length) {
            this.fGroups[i].fillContextMenu(menu);
            ++i;
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (this.fGroups == null) {
            return;
        }
        int i = 0;
        while (i < this.fGroups.length) {
            this.fGroups[i].setContext(context);
            ++i;
        }
    }

    public void updateActionBars() {
        super.updateActionBars();
        if (this.fGroups == null) {
            return;
        }
        int i = 0;
        while (i < this.fGroups.length) {
            this.fGroups[i].updateActionBars();
            ++i;
        }
    }
}

