/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kenya.eclipse.multieditor.kenya.KenyaEditor;
import kenya.eclipse.ui.ActionMessages;
import kenya.eclipse.ui.actions.RenameAction;
import kenya.eclipse.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class RefactorActionGroup
extends ActionGroup {
    public static final String MENU_ID = "kenya.eclipse.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    private IWorkbenchSite fSite;
    private KenyaEditor fEditor;
    private String fGroupName = "group.reorganize";
    private SelectionDispatchAction fRenameAction;
    private List fEditorActions;
    private Action fNoActionAvailable = new NoActionAvailable();

    public RefactorActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), part.getSite().getKeyBindingService());
    }

    public RefactorActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite(), null);
    }

    public RefactorActionGroup(KenyaEditor editor, String groupName) {
        this.fSite = editor.getEditorSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        ISelectionProvider provider = editor.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fEditorActions = new ArrayList();
        this.fRenameAction = new RenameAction(editor);
        this.fRenameAction.setActionDefinitionId("kenya.eclipse.multieditor.kenya.rename.element");
        this.fRenameAction.update(selection);
        editor.setAction("RenameElement", (IAction)this.fRenameAction);
        this.fEditorActions.add(this.fRenameAction);
    }

    private RefactorActionGroup(IWorkbenchSite site, IKeyBindingService keyBindingService) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fRenameAction = new RenameAction(site);
        this.fRenameAction.setActionDefinitionId("kenya.eclipse.multieditor.kenya.rename.element");
        RefactorActionGroup.initAction(this.fRenameAction, provider, selection);
    }

    private static void initAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("kenya.eclipse.ui.actions.Rename", (IAction)this.fRenameAction);
    }

    public void retargetFileMenuActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.addRefactorSubmenu(menu);
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        this.disposeAction(this.fRenameAction, provider);
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    private void addRefactorSubmenu(IMenuManager menu) {
        String shortCut = null;
        MenuManager refactorSubmenu = new MenuManager(String.valueOf(ActionMessages.getString("RefactorMenu.label")) + (shortCut != null ? "\t" + shortCut : ""), MENU_ID);
        if (this.fEditor != null) {
            refactorSubmenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    RefactorActionGroup.this.refactorMenuShown(manager);
                }
            });
            refactorSubmenu.add((IAction)this.fNoActionAvailable);
            menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
        } else if (this.fillRefactorMenu((IMenuManager)refactorSubmenu) > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
        }
    }

    private int fillRefactorMenu(IMenuManager refactorSubmenu) {
        int added = 0;
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG));
        return added += this.addAction(refactorSubmenu, (IAction)this.fRenameAction);
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private void refactorMenuShown(final IMenuManager refactorSubmenu) {
        Menu menu = ((MenuManager)refactorSubmenu).getMenu();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                RefactorActionGroup.this.refactorMenuHidden(refactorSubmenu);
            }
        });
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        Iterator iter = this.fEditorActions.iterator();
        while (iter.hasNext()) {
            SelectionDispatchAction action = (SelectionDispatchAction)((Object)iter.next());
            action.update((ISelection)textSelection);
        }
        refactorSubmenu.removeAll();
        if (this.fillRefactorMenu(refactorSubmenu) == 0) {
            refactorSubmenu.add((IAction)this.fNoActionAvailable);
        }
    }

    private void refactorMenuHidden(IMenuManager manager) {
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        Iterator iter = this.fEditorActions.iterator();
        while (iter.hasNext()) {
            SelectionDispatchAction action = (SelectionDispatchAction)((Object)iter.next());
            action.update((ISelection)textSelection);
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(true);
            this.setText("no refactoring available");
        }
    }
}

