/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ui.actions;

import java.util.Iterator;
import java.util.List;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.ast.AdvancedPositionFinder;
import kenya.eclipse.ast.IBinding;
import kenya.eclipse.ast.OccurrencesFinder;
import kenya.eclipse.ast.SimpleASTProvider;
import kenya.eclipse.ast.bindings.BuiltinMethodBinding;
import kenya.eclipse.ast.bindings.EnumBinding;
import kenya.eclipse.ast.bindings.EnumConstantBinding;
import kenya.eclipse.multieditor.kenya.KenyaEditor;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentModificationOperation;
import kenya.eclipse.multieditor.kenya.refactoring.DocumentTextOperation;
import kenya.eclipse.multieditor.kenya.util.LocationUtils;
import kenya.eclipse.ui.actions.SelectionDispatchAction;
import kenya.eclipse.ui.actions.Validator;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import minijava.node.Node;
import minijava.node.Start;
import minijava.node.TIdentifier;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchSite;

public class RenameAction
extends SelectionDispatchAction {
    private OccurrencesFinder fOccurrenceFinder;
    private KenyaEditor fEditor;

    public RenameAction(IWorkbenchSite site) {
        super(site);
        this.setText("Rename");
        this.fOccurrenceFinder = new OccurrencesFinder();
    }

    public RenameAction(KenyaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
    }

    public void selectionChanged(ISelection selection) {
        if (selection instanceof ITextSelection) {
            this.selectionChanged((ITextSelection)selection);
        }
    }

    public void update(ISelection selection) {
        super.update(selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
    }

    public void selectionChanged(ITextSelection selection) {
        try {
            IDocument doc = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
            this.setEnabled(this.computeEnabledState(doc, selection.getOffset(), selection.getLength()));
        }
        catch (NullPointerException nullPointerException) {
            this.setEnabled(false);
        }
    }

    private boolean computeEnabledState(IDocument doc, int offset, int length) {
        if (this.fEditor != null) {
            ICheckedCode currentcode = this.fEditor.getKenyaCodeManager().getLastCheckedCode();
            if (currentcode == null) {
                return false;
            }
            if (!currentcode.isErroredCode()) {
                Start start = SimpleASTProvider.getAST(currentcode);
                String msg = this.fOccurrenceFinder.initialize(start, currentcode, doc, offset, length);
                IBinding tgt = this.fOccurrenceFinder.getTarget();
                return msg == null && !(tgt instanceof EnumBinding) && !(tgt instanceof EnumConstantBinding) && !(tgt instanceof BuiltinMethodBinding);
            }
        }
        return false;
    }

    public void run(IStructuredSelection selection) {
    }

    public void run(ITextSelection selection) {
        this.selectionChanged(selection);
        if (!this.isEnabled()) {
            return;
        }
        IDocument doc = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        if (doc == null) {
            return;
        }
        List list = this.fOccurrenceFinder.perform();
        IBinding tgt = this.fOccurrenceFinder.getTarget();
        String initial = this.fOccurrenceFinder.getExpandedSelectionText();
        InputDialog d = new InputDialog(KenyaPlugin.getActiveWorkbenchShell(), "Rename..", "Please enter a new identifier.", initial, (IInputValidator)new Validator(tgt));
        d.create();
        int choice = d.open();
        if (choice != 0) {
            return;
        }
        String newId = d.getValue();
        if (newId.equals(initial)) {
            return;
        }
        DocumentModificationOperation op = new DocumentModificationOperation();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            TIdentifier tid = (TIdentifier)iter.next();
            String n = tid.getText();
            if (!n.equals(initial)) continue;
            ISourceCodeLocation loc = AdvancedPositionFinder.getFullLocation((Node)tid, doc);
            Position pos = LocationUtils.convert(loc, doc);
            DocumentTextOperation dto = DocumentTextOperation.newTextReplacement(pos.offset, pos.length, newId);
            op.addOperation(dto);
        }
        op.run(doc);
    }
}

