/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ui.actions;

import kenya.eclipse.KenyaConventions;
import kenya.eclipse.ast.IBinding;
import kenya.eclipse.ast.bindings.ClassBinding;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IInputValidator;

class Validator
implements IInputValidator {
    private IBinding tgt;

    public Validator(IBinding target) {
        this.tgt = target;
    }

    public String isValid(String txt) {
        boolean valid;
        if (txt == null || txt.length() == 0) {
            return "Name is empty";
        }
        if (KenyaConventions.clashesWithReservedWord(txt)) {
            return "Cannot give the same name as a reserved keyword.";
        }
        if (this.tgt instanceof ClassBinding) {
            IStatus st = KenyaConventions.validateKenyaTypeName(txt);
            switch (st.getSeverity()) {
                case 0: {
                    return null;
                }
            }
            return st.getMessage();
        }
        char[] cs = txt.toCharArray();
        boolean bl = valid = Character.isJavaIdentifierStart(cs[0]) && !Character.isDigit(cs[0]);
        if (!valid) {
            return "Identifiers must start with an underscore or letter.";
        }
        int i = 1;
        while (i < cs.length) {
            if (!valid) {
                return "Identifiers cannot contain spaces or other special characters.";
            }
            valid = Character.isJavaIdentifierPart(cs[i]);
            ++i;
        }
        return null;
    }
}

