/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ui.views;

import java.lang.reflect.Array;
import java.util.ArrayList;
import kenya.eclipse.KenyaPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class KenyaResourceNavigator
extends ResourceNavigator
implements IResourceChangeListener {
    static /* synthetic */ Class class$0;

    public KenyaResourceNavigator() {
        MatchMaker.addRegex(".*\\.k", true);
        MatchMaker.addRegex(".*\\.java", true);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void initFilters(TreeViewer viewer) {
        super.initFilters(viewer);
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IResource resource = null;
                if (element instanceof IProject) {
                    IProject pr = (IProject)element;
                    try {
                        if (!pr.isAccessible() || pr.hasNature("kenya.eclipse.kenyanature")) {
                            return true;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                } else {
                    if (element instanceof IFolder) {
                        IContainer p = ((IFolder)element).getParent();
                        return !((IResource)element).getName().equals("CVS") && this.select(viewer, p.getParent(), p);
                    }
                    if (element instanceof IResource) {
                        resource = (IResource)element;
                    } else if (element instanceof IAdaptable) {
                        IAdaptable adaptable = (IAdaptable)element;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        resource = (IResource)adaptable.getAdapter((Class)clazz);
                    }
                }
                if (resource != null) {
                    String name = resource.getName();
                    return MatchMaker.matches(name);
                }
                return false;
            }
        });
    }

    protected TreeViewer createViewer(Composite parent) {
        TreeViewer v = super.createViewer(parent);
        return v;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IWorkspaceRoot refresh = null;
        if (event.getType() != 1) {
            refresh = KenyaPlugin.getWorkspace().getRoot();
        } else if (event.getResource() != null) {
            IResourceDelta delta = event.getDelta();
            if (delta != null && (delta.getKind() & 4) == 0) {
                return;
            }
            refresh = event.getResource();
        } else {
            IMarkerDelta[] problemMarkerDelta = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
            if (Array.getLength(problemMarkerDelta) > 0) {
                refresh = problemMarkerDelta[0].getResource();
            }
        }
        if (refresh != null) {
            this.getViewer().getControl().getDisplay().asyncExec((Runnable)new ViewerUpdate(refresh));
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    private static class MatchMaker {
        static ArrayList regexs = new ArrayList();

        MatchMaker() {
        }

        static void addRegex(String regex, boolean match) {
            MatchMaker.addRegex(new RegEx(regex, match));
        }

        static void addRegex(RegEx regex) {
            regexs.add(regex);
        }

        static boolean matches(String input) {
            if (input == null) {
                return false;
            }
            int i = 0;
            while (i < regexs.size()) {
                RegEx r = (RegEx)regexs.get(i);
                if (input.matches(r.regex())) {
                    return r.match();
                }
                ++i;
            }
            return false;
        }

        static class RegEx {
            private String regex;
            private boolean match;

            RegEx(String regex, boolean match) {
                this.regex = regex;
                this.match = match;
            }

            String regex() {
                return this.regex;
            }

            boolean match() {
                return this.match;
            }
        }
    }

    private class ViewerUpdate
    implements Runnable {
        private final Object fElement;

        public ViewerUpdate(Object element) {
            this.fElement = element;
        }

        public void run() {
            KenyaResourceNavigator.this.getViewer().refresh(this.fElement, true);
        }
    }
}

