/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ui.wizards;

import kenya.eclipse.KenyaConventions;
import kenya.eclipse.ui.wizards.dialogfields.DialogField;
import kenya.eclipse.ui.wizards.dialogfields.LayoutUtil;
import kenya.eclipse.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import kenya.eclipse.ui.wizards.dialogfields.Separator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewKFileWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private ISelection selection;
    private SelectionButtonDialogFieldGroup fMethodStubsButtons;
    public static final int NO_MAIN = 0;
    public static final int CREATE_MAIN = 1;
    public static final int CREATE_MAIN_ARGS = 2;

    public NewKFileWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("Kenya File");
        this.setDescription("Create a new Kenya file (a 'class' in Java)");
        this.selection = selection;
        String[] buttonNames3 = new String[]{"none", "void main()", "void main(String[] args)"};
        this.fMethodStubsButtons = new SelectionButtonDialogFieldGroup(16, buttonNames3, 1);
        this.fMethodStubsButtons.setLabelText("Would you like to generate a main method?");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.setEditable(false);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewKFileWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewKFileWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&Type name:");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewKFileWizardPage.this.dialogChanged();
            }
        });
        DialogField.createEmptySpace(container);
        this.createSeparator(container, layout.numColumns);
        this.createMethodStubSelectionControls(container, layout.numColumns);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void createMethodStubSelectionControls(Composite composite, int nColumns) {
        Label labelControl = this.fMethodStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, nColumns);
        DialogField.createEmptySpace(composite);
        Composite buttonGroup = this.fMethodStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, nColumns - 1);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.fileText.setText("Exercise");
        this.fMethodStubsButtons.setSelection(1, true);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toOSString());
        }
    }

    private void dialogChanged() {
        String container = this.getContainerName();
        String typeName = this.getFileName();
        if (container == null || container.length() == 0) {
            this.updateStatus("Container is empty", 3);
            return;
        }
        Path file = new Path(String.valueOf(container) + '/' + typeName + ".k");
        if (ResourcesPlugin.getWorkspace().getRoot().exists((IPath)file)) {
            this.updateStatus("A file with the same name already exists at the specified location", 3);
            return;
        }
        IStatus status = KenyaConventions.validateKenyaTypeName(typeName);
        switch (status.getSeverity()) {
            case 4: {
                this.updateStatus(status.getMessage(), 3);
                return;
            }
            case 2: {
                this.updateStatus(status.getMessage(), 2);
                return;
            }
        }
        this.updateStatus(null, 0);
    }

    protected void updateStatus(String message, int type) {
        this.setMessage(message, type);
        this.setPageComplete(type != 3);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public int getMainMethodCreationType() {
        if (this.fMethodStubsButtons.isSelected(0)) {
            return 0;
        }
        if (this.fMethodStubsButtons.isSelected(1)) {
            return 1;
        }
        if (this.fMethodStubsButtons.isSelected(2)) {
            return 2;
        }
        return -1;
    }
}

