/*
 * Decompiled with CFR 0.152.
 */
package kenya.eclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.ui.KenyaImages;
import kenya.eclipse.ui.wizards.NewKenyaProjectCreationOperation;
import kenya.eclipse.ui.wizards.NewKenyaProjectCreationWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewProjectCreationWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IConfigurationElement fConfigElement;
    private NewKenyaProjectCreationWizardPage[] fPages;

    public NewProjectCreationWizard() {
        this.setDialogSettings(KenyaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle("New Kenya Project");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.fPages = new NewKenyaProjectCreationWizardPage[1];
        int i = 0;
        while (i < this.fPages.length) {
            this.fPages[i] = new NewKenyaProjectCreationWizardPage("page " + i);
            this.addPage((IWizardPage)this.fPages[i]);
            ++i;
        }
    }

    public boolean performFinish() {
        NewKenyaProjectCreationOperation runnable = new NewKenyaProjectCreationOperation(this.fPages);
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.handleException(e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        return true;
    }

    private void handleException(Throwable target) {
        String title = "Project Creation Failed";
        String message = "Project could not be created.";
        if (target instanceof CoreException) {
            IStatus status = ((CoreException)target).getStatus();
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)status);
            KenyaPlugin.log(status);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)target.getMessage());
            KenyaPlugin.log(target);
        }
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
        this.setDefaultPageImageDescriptor(KenyaImages.DESC_K_NPROJ_WIZBAN);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

