/*
 * Decompiled with CFR 0.152.
 */
package kenya.errors;

import java.io.IOException;
import java.io.StringReader;
import kenya.errors.IExceptionMapper;
import kenya.errors.SourceCodeException;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;

class ConstantExceptionMapper
implements IExceptionMapper {
    ConstantExceptionMapper() {
    }

    public SourceCodeException mapException(SourceCodeException sce) {
        if (sce.getInformationNumber() == 37) {
            StringBuffer javacBuffer = new StringBuffer();
            StringReader javacReader = sce.getJavacStyleMessage();
            try {
                int c = javacReader.read();
                while (c != -1) {
                    javacBuffer.append((char)c);
                    c = javacReader.read();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            return new SourceCodeException(new String[]{javacBuffer.toString(), "You cannot use a function call in a constant declaration"}, ConstantExceptionMapper.convertSourceCodeLocation(sce.getLocation()), null, sce._errID);
        }
        return sce;
    }

    private static int[] convertSourceCodeLocation(ISourceCodeLocation iscl) {
        return new int[]{iscl.getLineNumber(), iscl.getColumnNumber(), iscl.getTokenLength()};
    }
}

