/*
 * Decompiled with CFR 0.152.
 */
package kenya.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import kenya.nio.IKenyaNIO;

public class KenyaNIO
implements IKenyaNIO {
    private static KenyaNIO _single;
    private InputStreamReader isr;
    private StreamTokenizer tokenizer;
    private PrintStream out = null;

    public static IKenyaNIO get() {
        if (_single == null) {
            _single = new KenyaNIO(System.in);
        }
        return _single;
    }

    public static IKenyaNIO get(InputStream is) {
        return new KenyaNIO(is);
    }

    private KenyaNIO(InputStream is) {
        this.isr = new InputStreamReader(is);
        this.tokenizer = new StreamTokenizer(this.isr);
        this.tokenizer.resetSyntax();
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.wordChars(33, 255);
    }

    public boolean isEOF() {
        try {
            if (this.tokenizer.nextToken() == -1) {
                return true;
            }
            this.tokenizer.pushBack();
            return false;
        }
        catch (IOException e) {
            if (this.out != null) {
                this.out.println(e.toString());
            }
            return false;
        }
    }

    public int readInt() {
        try {
            this.tokenizer.resetSyntax();
            this.tokenizer.whitespaceChars(0, 32);
            this.tokenizer.wordChars(33, 255);
            if (this.tokenizer.nextToken() == -1) {
                throw new IOException("End Of File found.");
            }
            return (int)Double.parseDouble(this.tokenizer.sval);
        }
        catch (NumberFormatException nfe) {
            return this.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double readDouble() {
        this.tokenizer.resetSyntax();
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.wordChars(33, 255);
        try {
            if (this.tokenizer.nextToken() == -1) {
                throw new IOException("End Of File found.");
            }
            return Double.parseDouble(this.tokenizer.sval);
        }
        catch (NumberFormatException nfe) {
            return this.readDouble();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String readString() {
        this.tokenizer.resetSyntax();
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.wordChars(33, 255);
        try {
            if (this.tokenizer.nextToken() == -1) {
                throw new IOException("End Of File found.");
            }
            return this.tokenizer.sval;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public char readChar() {
        this.tokenizer.resetSyntax();
        this.tokenizer.whitespaceChars(32, 32);
        try {
            if (this.tokenizer.nextToken() == -1) {
                throw new IOException("End Of File found.");
            }
            return (char)this.tokenizer.ttype;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public char read() {
        char c = ' ';
        try {
            c = (char)this.isr.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return c;
    }

    public boolean failedLastRead() {
        return false;
    }

    public void setPrintStream(PrintStream out) {
        this.out = out;
    }
}

