/*
 * Decompiled with CFR 0.152.
 */
package kenya.passes;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kenya.errors.SourceCodeException;
import kenya.passes.TypeChecker;
import kenya.passes.Util;
import kenya.types.KBasicType;
import kenya.types.KType;
import kenya.types.tables.ClassTable;
import kenya.types.tables.SymbolTable;
import minijava.node.AInitialiser;
import minijava.node.Node;
import minijava.node.PArrayInitialiser;

final class RestrictedTypeChecker {
    RestrictedTypeChecker() {
    }

    private static List apply(ClassTable ct, SymbolTable st, Map paramMap, KType retType, Node start, Set errNodes, Map typeMap, int ln, int pos, int len) {
        TypeChecker tc = new TypeChecker(ct, st, paramMap, errNodes, typeMap, retType);
        if (retType == KBasicType.getChar()) {
            tc.setWantChar();
        }
        start.apply(tc);
        KType actRetType = tc.getTopOfTypeStack();
        List errors = tc.getErrors();
        if (!Util.isAssignmentCompatible(retType, actRetType)) {
            try {
                SourceCodeException.throwIncompatibleTypes_Assignment(ln, pos, len, retType, actRetType);
            }
            catch (SourceCodeException sce) {
                errors.add(sce);
            }
        }
        return errors;
    }

    static List apply(ClassTable ct, SymbolTable st, Map paramMap, KType retType, Set errorNodes, AInitialiser start, Map typeMap) {
        int ln = start.getAssign().getLine();
        int pos = start.getAssign().getPos();
        int len = start.getAssign().getText().trim().length();
        return RestrictedTypeChecker.apply(ct, st, paramMap, retType, start, errorNodes, typeMap, ln, pos, len);
    }

    static List apply(ClassTable ct, SymbolTable st, Map paramMap, KType retType, Set errorNodes, PArrayInitialiser start, Map typeMap) {
        int[] pos = Util.getFirstIdent(start);
        return RestrictedTypeChecker.apply(ct, st, paramMap, retType, start, errorNodes, typeMap, pos[0], pos[1], pos[2]);
    }
}

