/*
 * Decompiled with CFR 0.152.
 */
package kenya.passes;

import org.wellquite.kenya.stackMachine.ops.ControlFlowOpsFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IHaltableClosure;

class SwitchHelper {
    private IAtomicClosure _cond;
    private int cPos = -1;
    private IAtomicClosure[] _cases;
    private IAtomicClosure[] _stats;
    private int _defaultPos;

    SwitchHelper() {
    }

    void setCond(IAtomicClosure cond) {
        if (this._cond != null) {
            throw new IllegalStateException("Attepting to set a condition that has already been set.");
        }
        this._cond = cond;
    }

    void initArrays(int size) {
        if (this._cases != null) {
            throw new IllegalStateException("Attempting to initialise arrays that are already initialised");
        }
        this._defaultPos = -1;
        this.cPos = 0;
        this._cases = new IAtomicClosure[size];
        this._stats = new IAtomicClosure[size];
    }

    void setNextCase(IAtomicClosure cases, IAtomicClosure stats) {
        if (cases == null) {
            this._defaultPos = this.cPos;
        }
        this._cases[this.cPos] = cases;
        this._stats[this.cPos] = stats;
        ++this.cPos;
    }

    IHaltableClosure getSwitchClosure() {
        if (this._stats == null || this.cPos != this._stats.length) {
            throw new IllegalStateException("Attempting to get Switch Closure from improperly set up SwitchHelper");
        }
        return ControlFlowOpsFactory.switchClosure(this._cond, this._cases, this._stats, this._defaultPos);
    }
}

