/*
 * Decompiled with CFR 0.152.
 */
package mediator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kenya.builtIns.BuiltInMethod;
import kenya.builtIns.BuiltInMethodsLoader;
import kenya.errors.SourceCodeException;
import kenya.io.VariablePushbackReader;
import kenya.passes.DefinitionFinder;
import kenya.passes.RestrictedStructureChecker;
import kenya.passes.StructureChecker;
import kenya.passes.TypeChecker;
import kenya.passes.TypeFinder;
import kenya.types.KClassType;
import kenya.types.KFunction;
import kenya.types.tables.ClassTable;
import kenya.types.tables.FunctionTable;
import kenya.types.tables.SymbolTable;
import kenya.types.tables.VariableTable;
import mediator.ICheckedCode;
import mediator.InvalidCode;
import mediator.PartiallyCheckedCode;
import mediator.ValidCode;
import mediator.util.InformationHolder;
import mediator.util.ValidMainChecker;
import minijava.lexer.Lexer;
import minijava.lexer.LexerException;
import minijava.node.Start;
import minijava.parser.Parser;
import minijava.parser.ParserException;

public class Mediator {
    public static final int DBG_MESSAGES = 1;
    public static final int DBG_PARSE = 2;
    public static final int DBG_TYPEFIND = 4;
    public static final int DBG_DEFINITIONFIND = 8;
    public static final int DBG_BUILTINLOAD = 16;
    public static final int DBG_TYPECHECK = 32;
    public static final int DBG_STRUCTURECHECK = 64;

    public static ICheckedCode check(Reader in) throws IOException {
        return Mediator.check(in, 0, null);
    }

    public static synchronized ICheckedCode check(Reader in, int dbg, PrintStream debug) throws IOException {
        String name;
        int i;
        Start ast;
        LinkedList<SourceCodeException> errors = new LinkedList<SourceCodeException>();
        if (Mediator.isOpt(dbg, 1)) {
            debug.println(">>>Parsing");
        }
        try {
            Parser parser = new Parser(new Lexer(new VariablePushbackReader(new BufferedReader(in))));
            ast = parser.parse();
        }
        catch (LexerException e) {
            errors.add(SourceCodeException.wrapLexerException(e));
            return new InvalidCode(errors, new InformationHolder(new ClassTable(), new FunctionTable(), new VariableTable(), null, null, new HashMap(), new HashMap(), null));
        }
        catch (ParserException e) {
            errors.add(SourceCodeException.wrapParserException(e));
            return new InvalidCode(errors, new InformationHolder(new ClassTable(), new FunctionTable(), new VariableTable(), null, null, new HashMap(), new HashMap(), null));
        }
        if (Mediator.isOpt(dbg, 1)) {
            debug.println("<<<Parsing");
        }
        if (Mediator.isOpt(dbg, 2)) {
            return new PartiallyCheckedCode(errors, new InformationHolder(new ClassTable(), new FunctionTable(), new VariableTable(), null, null, new HashMap(), new HashMap(), ast));
        }
        ClassTable classTable = new ClassTable();
        classTable.put("Boolean", KClassType.getBoolean(), null);
        classTable.put("Character", KClassType.getCharacter(), null);
        classTable.put("Integer", KClassType.getInteger(), null);
        classTable.put("Double", KClassType.getDouble(), null);
        if (Mediator.isOpt(dbg, 1)) {
            debug.println(">>>TypeFinder");
        }
        TypeFinder tfa = new TypeFinder(classTable);
        ast.apply(tfa);
        errors.addAll(tfa.getErrors());
        if (Mediator.isOpt(dbg, 1)) {
            debug.println("<<<TypeFinder");
        }
        if (Mediator.isOpt(dbg, 4)) {
            return new PartiallyCheckedCode(errors, new InformationHolder(new ClassTable(), new FunctionTable(), new VariableTable(), null, null, new HashMap(), new HashMap(), ast));
        }
        if (Mediator.isOpt(dbg, 1)) {
            debug.println(">>>DefinitionFinder");
        }
        HashMap typeMap = new HashMap();
        Set errorNodes = tfa.getErrorNodes();
        DefinitionFinder df = new DefinitionFinder(tfa.getClassTable(), errorNodes, typeMap);
        ast.apply(df);
        errors.addAll(df.getErrors());
        if (Mediator.isOpt(dbg, 1)) {
            debug.println("<<<DefinitionFinder");
        }
        if (Mediator.isOpt(dbg, 8)) {
            return new PartiallyCheckedCode(errors, new InformationHolder(classTable, df.getFunctions(), new VariableTable(), null, null, new HashMap(), new HashMap(), ast));
        }
        if (Mediator.isOpt(dbg, 1)) {
            debug.println(">>>Builtins");
        }
        Set builtins = BuiltInMethodsLoader.getBuiltInMethods();
        Iterator it = builtins.iterator();
        FunctionTable functionTable = df.getFunctions();
        while (it.hasNext()) {
            BuiltInMethod bim = (BuiltInMethod)it.next();
            KFunction kf = new KFunction(bim.getName(), bim.getTemplateParameters(), bim.getReturnType(), bim.getMethodParameters(), null, bim, null);
            try {
                functionTable.add(kf, true);
            }
            catch (SourceCodeException sce) {
                errors.add(sce);
            }
        }
        if (Mediator.isOpt(dbg, 1)) {
            debug.println("<<<Builtins");
        }
        if (Mediator.isOpt(dbg, 16)) {
            return new PartiallyCheckedCode(errors, new InformationHolder(df.getClassTable(), functionTable, new VariableTable(), null, null, new HashMap(), new HashMap(), ast));
        }
        if (Mediator.isOpt(dbg, 1)) {
            debug.println(">>>TypeChecker");
        }
        LinkedList warnings = new LinkedList();
        SymbolTable globalsSymbolTable = df.getGlobalSymbolTable();
        TypeChecker typechecker = new TypeChecker(classTable, globalsSymbolTable, functionTable, errorNodes, typeMap);
        ast.apply(typechecker);
        if (typechecker.getErrors().size() != 0) {
            errors.addAll(typechecker.getErrors());
        }
        warnings.addAll(typechecker.getWarnings());
        if (Mediator.isOpt(dbg, 1)) {
            debug.println("<<<TypeChecker");
        }
        if (Mediator.isOpt(dbg, 32)) {
            return new PartiallyCheckedCode(errors, new InformationHolder(classTable, functionTable, new VariableTable(), null, null, new HashMap(), new HashMap(), ast));
        }
        if (Mediator.isOpt(dbg, 1)) {
            debug.println(">>>StructureChecker");
        }
        Map funcMap = typechecker.getFuncMap();
        Set tcErrorNodes = typechecker.getErrorNodes();
        Set arrayLengths = typechecker.getArrayLengthRefs();
        Set enumChildSet = typechecker.getEnumChildSet();
        VariableTable variableTable = RestrictedStructureChecker.processConstants(ast, typeMap, tcErrorNodes, arrayLengths, enumChildSet, warnings, errors);
        StructureChecker sc = new StructureChecker(classTable, globalsSymbolTable, functionTable, variableTable, tcErrorNodes, typeMap, funcMap, arrayLengths, enumChildSet);
        ast.apply(sc);
        errors.addAll(sc.getErrors());
        warnings.addAll(sc.getInfos());
        if (Mediator.isOpt(dbg, 1)) {
            debug.println("<<<StructureChecker");
        }
        if (Mediator.isOpt(dbg, 64)) {
            return new PartiallyCheckedCode(errors, warnings, new InformationHolder(classTable, functionTable, variableTable, enumChildSet, arrayLengths, funcMap, typeMap, ast));
        }
        InformationHolder ih = new InformationHolder(classTable, functionTable, variableTable, enumChildSet, arrayLengths, funcMap, typeMap, ast);
        ValidMainChecker vmc = new ValidMainChecker(ih);
        if (!vmc.haveMainWithStringArgs() && !vmc.haveMainNoArgs()) {
            errors.add(SourceCodeException.noValidMainFunction());
        }
        HashSet<String> badClassNames = new HashSet<String>();
        badClassNames.addAll(Arrays.asList("Boolean", "Character", "Integer", "Double", "String", "Object"));
        HashSet funcClasses = new HashSet();
        Iterator it2 = funcMap.keySet().iterator();
        while (it2.hasNext()) {
            KFunction kf = (KFunction)funcMap.get(it2.next());
            if (!kf.isBuiltin()) continue;
            funcClasses.addAll(kf.getBuiltinMethod().getReservedClasses());
        }
        for (i = 0; i < ih.getClasses().length; ++i) {
            name = ih.getClasses()[i].getName();
            if (badClassNames.contains(name)) {
                errors.add(SourceCodeException.badClassName(ih.getClasses()[i].getPosition(), name));
                continue;
            }
            if (!funcClasses.contains(name)) continue;
            errors.add(SourceCodeException.badClassBuiltinName(ih.getClasses()[i].getPosition(), name));
        }
        for (i = 0; i < ih.getEnums().length; ++i) {
            name = ih.getEnums()[i].getName();
            if (badClassNames.contains(name)) {
                errors.add(SourceCodeException.badEnumName(ih.getEnums()[i].getPosition(), name));
                continue;
            }
            if (!funcClasses.contains(name)) continue;
            errors.add(SourceCodeException.badEnumBuiltinName(ih.getClasses()[i].getPosition(), name));
        }
        if (errors.size() == 0) {
            return new ValidCode(warnings, ih, vmc, funcMap, typeMap);
        }
        return new InvalidCode(errors, warnings, ih);
    }

    private static boolean isOpt(int dbg, int opt) {
        return (dbg & opt) == opt;
    }
}

