/*
 * Decompiled with CFR 0.152.
 */
package mediator.stackMachine;

import java.util.List;
import kenya.errors.KenyaPreconditionError;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.stackMachine.IStackMachineInformationProvider;
import mediator.stackMachine.StackMachineInformationManager;
import mediator.util.ValidMainChecker;
import org.wellquite.kenya.stackMachine.InterpretedBuildableClosure;
import org.wellquite.kenya.stackMachine.InterpretedMethod;
import org.wellquite.kenya.stackMachine.ops.StackOpsFactory;
import org.wellquite.kenya.stackMachine.types.ClassTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;

class StackMachineInformationProvider
implements IStackMachineInformationProvider {
    private static final String INIT_METHOD_NAME = "<INIT_METHOD>";
    private final StackMachineInformationManager _ismim;
    private final ValidMainChecker _vmc;
    private final List _codePoints;
    private final IAtomicClosure _preInitClosure;

    public StackMachineInformationProvider(StackMachineInformationManager ismim, ValidMainChecker vmc) {
        this._ismim = ismim;
        this._vmc = vmc;
        this._codePoints = ismim._codePoints;
        InterpretedMethod iim = new InterpretedMethod(INIT_METHOD_NAME, this._ismim.getGlobalClassBody(), true, false);
        this._ismim.getGlobalClassBody().addStaticMethod(iim);
        iim.setMethodBody(this._ismim._preInitClosure);
        InterpretedBuildableClosure ibc = new InterpretedBuildableClosure();
        ibc.addClosure(StackOpsFactory.push(ClassTypeFactory.createClassStaticType(this.getEntryPointClass())));
        ibc.addClosure(StackOpsFactory.invokeForeignStaticMethod(INIT_METHOD_NAME));
        this._preInitClosure = ibc;
    }

    public boolean entryPointTakesArguments() {
        return this._vmc.haveMainWithStringArgs();
    }

    public String getEntryPoint() {
        IFunction mainFunc;
        if (this._vmc.haveMainWithStringArgs()) {
            mainFunc = this._vmc.getMainWithStringArgs();
        } else if (this._vmc.haveMainNoArgs()) {
            mainFunc = this._vmc.getMainWithNoArgs();
        } else {
            throw KenyaPreconditionError.get();
        }
        return this._ismim.lookupFunction(mainFunc);
    }

    public IInterpretedClass getEntryPointClass() {
        return this._ismim.getGlobalClassBody();
    }

    public IClass lookupClass(String name) {
        IClass cls = (IClass)this._ismim._classMap.lookupLHS(name);
        if (cls == null) {
            return null;
        }
        return (IClass)this._ismim._normClassMap.lookupRHS(cls);
    }

    public IClass lookupEnum(String name) {
        IClass enu = (IClass)this._ismim._enumMap.lookupLHS(name);
        if (enu == null) {
            return null;
        }
        return (IClass)this._ismim._normEnumMap.lookupRHS(enu);
    }

    public IFunction lookupFunction(String name) {
        IFunction iff = (IFunction)this._ismim._funcMap.lookupLHS(name);
        if (iff == null) {
            return null;
        }
        return (IFunction)this._ismim._normFuncMap.lookupRHS(iff);
    }

    public IVariable lookupVariable(String name) {
        IVariable ivar = (IVariable)this._ismim._varMap.lookupLHS(name);
        if (ivar == null) {
            return null;
        }
        return (IVariable)this._ismim._normVarMap.lookupRHS(ivar);
    }

    public IAtomicClosure getPreInitClosure() {
        return this._preInitClosure;
    }

    public List getDiscreteExecutionPointMarkersFromTheAST() {
        return this._codePoints;
    }
}

