/*
 * Decompiled with CFR 0.152.
 */
package mediator.subscription;

import java.io.IOException;
import java.io.Reader;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.Mediator;
import mediator.subscription.ICheckedCodeReceiver;
import mediator.subscription.IJavaCodeReceiver;
import mediator.subscription.ISubscriptionData;
import mediator.subscription.ISubscriptionTerms;
import mediator.subscription.MediatorInput;

public class MediationTerms
implements ISubscriptionTerms {
    private final MediatorInput input;
    private final ICheckedCodeReceiver[] iccr;
    private final IJavaCodeReceiver[] ijcr;
    private ISubscriptionData returnData = null;

    public MediationTerms(MediatorInput input, ICheckedCodeReceiver iccr, IJavaCodeReceiver ijcr) {
        this(input, new ICheckedCodeReceiver[]{iccr}, new IJavaCodeReceiver[]{ijcr});
    }

    public MediationTerms(MediatorInput input, ICheckedCodeReceiver[] iccr, IJavaCodeReceiver[] ijcr) {
        this.input = input;
        this.iccr = iccr;
        this.ijcr = ijcr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTerms() {
        Reader in;
        Reader reader = in = this.input != null ? this.input.getReader() : null;
        if (in == null) {
            this.returnData = new ISubscriptionData(){

                public Object[] getContents() {
                    return new Object[]{new RuntimeException()};
                }
            };
            return;
        }
        try {
            IJavaCode jc;
            final ICheckedCode checkedCode = Mediator.check(in);
            if (this.iccr != null) {
                for (int i = 0; i < this.iccr.length; ++i) {
                    this.iccr[i].setCheckedCode(checkedCode);
                }
            }
            IJavaCode iJavaCode = jc = checkedCode.isErroredCode() ? null : checkedCode.translate();
            if (this.ijcr != null) {
                for (int i = 0; i < this.ijcr.length; ++i) {
                    this.ijcr[i].setJavaCode(jc);
                }
            }
            this.returnData = new ISubscriptionData(){

                public Object[] getContents() {
                    return new Object[]{checkedCode, jc};
                }
            };
        }
        catch (IOException e) {
            this.returnData = new ISubscriptionData(){

                public Object[] getContents() {
                    return new Object[]{e};
                }
            };
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public ISubscriptionData getReturnData() {
        return this.returnData;
    }
}

