/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine;

import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.ClosureScope;
import org.wellquite.kenya.stackMachine.scope.IClosureScope;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;

public class ClosureMiscHelper {
    public static void executeClosureInScope(IClosureScope oldScope, IAtomicClosure closure, StackMachine sm) {
        ClosureScope newScope = new ClosureScope();
        try {
            if (oldScope != null) {
                newScope.setPreviousScope(oldScope);
                oldScope.setNextScope(newScope);
                oldScope.switchToNextScope(sm);
            }
            closure.setClosureScope(newScope);
            newScope.setClosure(closure);
            closure.execute(sm);
        }
        catch (RuntimeException re) {
            IClosureScope firstScope = newScope;
            while (firstScope.getPreviousScope() != null) {
                firstScope = firstScope.getPreviousScope();
            }
            firstScope.setReturn(true);
            throw re;
        }
        finally {
            closure.unsetClosureScope(newScope);
            newScope.switchToPreviousScope(sm);
        }
    }
}

