/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.misc;

import java.util.List;
import org.wellquite.kenya.stackMachine.misc.AbstractJob;
import org.wellquite.kenya.stackMachine.misc.JobDispatch;

public class JobRunner
implements Runnable {
    private final Object lock;
    private final List outStandingJobs;
    private boolean idle = true;
    private boolean running = false;
    private AbstractJob myJob = null;

    public JobRunner(Object lock, List jobsList) {
        this.lock = lock;
        this.outStandingJobs = jobsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunning(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            JobRunner jobRunner = this;
            synchronized (jobRunner) {
                this.running = value;
                this.lock.notifyAll();
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private synchronized void setIdle(boolean value) {
        this.idle = value;
        if (this.idle) {
            Thread.currentThread().setName("Idle Thread");
        }
    }

    public synchronized boolean isIdle() {
        return this.idle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setIdle(true);
        this.setRunning(true);
        while (JobDispatch.isThreadRunning(this)) {
            Object object = this.lock;
            synchronized (object) {
                while (this.outStandingJobs.size() == 0 && JobDispatch.isThreadRunning(this)) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.outStandingJobs.size() != 0) {
                    this.setIdle(false);
                    this.myJob = (AbstractJob)this.outStandingJobs.remove(0);
                    Thread.currentThread().setName("Thread running: " + this.myJob);
                }
            }
            if (this.myJob != null) {
                try {
                    this.myJob.execute();
                }
                catch (RuntimeException e) {
                    this.setRunning(false);
                    this.setIdle(true);
                    JobDispatch.threadExiting(this);
                    throw e;
                }
                this.myJob.finished();
                this.myJob = null;
            }
            this.setIdle(true);
        }
        this.setRunning(false);
        this.setIdle(true);
        JobDispatch.threadExiting(this);
    }
}

