/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.ops;

import org.wellquite.kenya.stackMachine.ClosureMiscHelper;
import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.ops.LogicalOpsFactory;
import org.wellquite.kenya.stackMachine.scope.IClosureScope;
import org.wellquite.kenya.stackMachine.types.AbstractHaltableClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IBooleanType;
import org.wellquite.kenya.stackMachine.types.interfaces.IHaltableClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class ControlFlowOpsFactory {
    private ControlFlowOpsFactory() {
    }

    public static IHaltableClosure ifClosure(final IAtomicClosure conditionClosure, final IAtomicClosure trueClosure, final IAtomicClosure falseClosure) {
        return new AbstractHaltableClosure(){

            public synchronized void execute(StackMachine sm) {
                IClosureScope scope = this.getClosureScope();
                if (scope == null) {
                    throw new IllegalStateException("Can't execute closure without a scope.");
                }
                ClosureMiscHelper.executeClosureInScope(scope, conditionClosure, sm);
                if (scope.getReturn()) {
                    return;
                }
                boolean result = ((IBooleanType)sm.pop()).getValue();
                if (scope.getReturn()) {
                    return;
                }
                if (result && trueClosure != null) {
                    if (scope.getReturn()) {
                        return;
                    }
                    ClosureMiscHelper.executeClosureInScope(scope, trueClosure, sm);
                } else if (!result && falseClosure != null) {
                    if (scope.getReturn()) {
                        return;
                    }
                    ClosureMiscHelper.executeClosureInScope(scope, falseClosure, sm);
                }
            }

            public String toString() {
                return "IfClosure:\n{\n\tcondition: <" + conditionClosure + ">\n\ttrueClosure: <" + trueClosure + ">\n\tfalseClosure: <" + falseClosure + ">\n}\n";
            }
        };
    }

    public static IHaltableClosure whileClosure(final IAtomicClosure conditionClosure, final IAtomicClosure bodyClosure) {
        return new AbstractHaltableClosure(){

            public synchronized void execute(StackMachine sm) {
                IClosureScope scope = this.getClosureScope();
                if (scope == null) {
                    throw new IllegalStateException("Can't execute closure without a scope.");
                }
                ClosureMiscHelper.executeClosureInScope(scope, conditionClosure, sm);
                if (scope.getReturn()) {
                    return;
                }
                boolean result = ((IBooleanType)sm.pop()).getValue();
                if (scope.getReturn()) {
                    return;
                }
                while (result) {
                    if (bodyClosure != null) {
                        ClosureMiscHelper.executeClosureInScope(scope, bodyClosure, sm);
                    }
                    if (scope.getReturn()) {
                        return;
                    }
                    ClosureMiscHelper.executeClosureInScope(scope, conditionClosure, sm);
                    if (scope.getReturn()) {
                        return;
                    }
                    result = ((IBooleanType)sm.pop()).getValue();
                    if (!scope.getReturn()) continue;
                    return;
                }
            }

            public String toString() {
                return "whileClosure:\n{\n\tcondition: <" + conditionClosure + ">\n\tbody: <" + bodyClosure + ">\n}\n";
            }
        };
    }

    public static IHaltableClosure switchClosure(final IAtomicClosure cond, final IAtomicClosure[] cases, final IAtomicClosure[] statements, final int defaultCase) {
        return new AbstractHaltableClosure(){

            public synchronized void execute(StackMachine sm) {
                int i;
                IClosureScope scope = this.getClosureScope();
                if (scope == null) {
                    throw new IllegalStateException("Can't execute closure without a scope.");
                }
                ClosureMiscHelper.executeClosureInScope(scope, cond, sm);
                if (scope.getReturn()) {
                    return;
                }
                IType result = sm.pop();
                if (scope.getReturn()) {
                    return;
                }
                int startCase = -1;
                for (i = 0; i < cases.length; ++i) {
                    if (i == defaultCase) continue;
                    ClosureMiscHelper.executeClosureInScope(scope, cases[i], sm);
                    if (scope.getReturn()) {
                        return;
                    }
                    sm.push(result);
                    if (scope.getReturn()) {
                        return;
                    }
                    ClosureMiscHelper.executeClosureInScope(scope, LogicalOpsFactory.equal(), sm);
                    if (scope.getReturn()) {
                        return;
                    }
                    boolean res = ((IBooleanType)sm.pop()).getValue();
                    if (scope.getReturn()) {
                        return;
                    }
                    if (!res) continue;
                    startCase = i;
                    break;
                }
                if (startCase == -1) {
                    startCase = defaultCase;
                }
                for (i = startCase; i != -1 && i < statements.length; ++i) {
                    ClosureMiscHelper.executeClosureInScope(scope, statements[i], sm);
                    if (!scope.getReturn()) continue;
                    return;
                }
            }

            public String toString() {
                return "switch: \n{\n\tcases: <" + cases + ">\n\tstatements: <" + statements + ">\n}\n";
            }
        };
    }
}

