/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.ops;

import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.types.AbstractAtomicClosure;
import org.wellquite.kenya.stackMachine.types.PrimitiveTypeFactory;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;
import org.wellquite.kenya.stackMachine.types.interfaces.ICharType;
import org.wellquite.kenya.stackMachine.types.interfaces.INullType;
import org.wellquite.kenya.stackMachine.types.interfaces.INumericType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

public class PrimitiveTypeConversionOpsFactory {
    private static final IAtomicClosure toChar = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType toConvert = sm.pop();
            if (toConvert instanceof INumericType) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType((char)((INumericType)toConvert).getValue().intValue()));
            } else if (toConvert instanceof ICharType) {
                sm.push(toConvert);
            } else {
                if (toConvert instanceof INullType) {
                    throw new NullPointerException();
                }
                throw new RuntimeException("Failed Precondition");
            }
        }

        public String toString() {
            return "(char)";
        }
    };
    private static final IAtomicClosure toInt = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType toConvert = sm.pop();
            if (toConvert instanceof INumericType) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(((INumericType)toConvert).getValue().intValue()));
            } else if (toConvert instanceof ICharType) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType((int)((ICharType)toConvert).getValue().charValue()));
            } else {
                if (toConvert instanceof INullType) {
                    throw new NullPointerException();
                }
                throw new RuntimeException("Failed Precondition" + toConvert);
            }
        }

        public String toString() {
            return "(int)";
        }
    };
    private static final IAtomicClosure toDouble = new AbstractAtomicClosure(){

        public void execute(StackMachine sm) {
            IType toConvert = sm.pop();
            if (toConvert instanceof INumericType) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType(((INumericType)toConvert).getValue().doubleValue()));
            } else if (toConvert instanceof ICharType) {
                sm.push(PrimitiveTypeFactory.createPrimitiveType((double)((ICharType)toConvert).getValue().charValue()));
            } else {
                if (toConvert instanceof INullType) {
                    throw new NullPointerException();
                }
                throw new RuntimeException("Failed Precondition");
            }
        }

        public String toString() {
            return "(double)";
        }
    };

    public static IAtomicClosure toChar() {
        return toChar;
    }

    public static IAtomicClosure toInt() {
        return toInt;
    }

    public static IAtomicClosure toDouble() {
        return toDouble;
    }
}

