/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.scope;

import org.wellquite.kenya.stackMachine.StackMachine;
import org.wellquite.kenya.stackMachine.scope.IClosureScope;
import org.wellquite.kenya.stackMachine.types.interfaces.IAtomicClosure;

public class ClosureScope
implements IClosureScope {
    private IClosureScope previousScope = null;
    private IClosureScope nextScope = null;
    private boolean returnFromThisScope = false;
    private IAtomicClosure closure = null;

    public synchronized IClosureScope getPreviousScope() {
        return this.previousScope;
    }

    public synchronized void setPreviousScope(IClosureScope previousScope) {
        this.previousScope = previousScope;
    }

    public synchronized void switchToPreviousScope(StackMachine sm) {
        if (this.previousScope == null) {
            throw new IllegalStateException("Can't switch to null previous scope.");
        }
        if (this.previousScope.getNextScope() == this) {
            this.previousScope.setNextScope(null);
        }
        sm.setClosureScope(this.getPreviousScope());
        this.previousScope = null;
    }

    public synchronized void setReturn(boolean value) {
        this.returnFromThisScope = value;
        if (value && this.nextScope != null) {
            this.nextScope.setReturn(true);
        }
    }

    public synchronized boolean getReturn() {
        return this.returnFromThisScope;
    }

    public synchronized void setNextScope(IClosureScope nextScope) {
        if (this.nextScope != null && this.nextScope.getPreviousScope() == this) {
            this.nextScope.setPreviousScope(null);
        }
        this.nextScope = nextScope;
    }

    public synchronized IClosureScope getNextScope() {
        return this.nextScope;
    }

    public synchronized void switchToNextScope(StackMachine sm) {
        if (this.getNextScope() == null) {
            throw new IllegalStateException("Can't switch to null next scope.");
        }
        sm.setClosureScope(this.getNextScope());
    }

    public synchronized IAtomicClosure getClosure() {
        return this.closure;
    }

    public synchronized void setClosure(IAtomicClosure closure) {
        this.closure = closure;
    }
}

