/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.types;

import org.wellquite.kenya.stackMachine.types.interfaces.IClassStaticType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;

public class ClassStaticType
implements IClassStaticType {
    private IInterpretedClass value = null;
    private boolean assigned = false;

    public ClassStaticType(IInterpretedClass value) {
        this.value = value;
        this.assigned = true;
    }

    public synchronized IInterpretedClass getValue() {
        return this.value;
    }

    public synchronized void setValue(IInterpretedClass value) {
        if (this.assigned) {
            ClassStaticType.modificationError(this);
        } else {
            this.value = value;
            this.assigned = true;
        }
    }

    public synchronized String toString() {
        return "ClassInstanceType: " + this.value;
    }

    public synchronized boolean valueSet() {
        return this.assigned;
    }

    public String getValueClassName() {
        return this.value.getName() + ":static";
    }

    private static void modificationError(ClassStaticType variable) {
        throw new RuntimeException("Attempt made to modify String variable: " + variable);
    }

    public String valueToString() {
        return this.value.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IClassStaticType) {
            return ((IClassStaticType)obj).getValue().equals(this.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public String getTypeName() {
        return this.value.getName();
    }

    public Object clone() throws CloneNotSupportedException {
        ClassStaticType t = (ClassStaticType)super.clone();
        return t;
    }
}

