/*
 * Decompiled with CFR 0.152.
 */
package kenya.errors;

import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kenya.errors.KenyaInternalError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import kenya.types.KClassType;
import kenya.types.KType;
import kenya.types.KVariable;
import mediator.IJavaCode;
import minijava.lexer.LexerException;
import minijava.parser.ParserException;

public class SourceCodeException
extends RuntimeException
implements ISourceCodeError {
    private static final long serialVersionUID = 3449404L;
    public static final int JAVAC_MESSAGE = 0;
    public static final int HUMAN_MESSAGE = 1;
    public static final int LINE_NUM = 0;
    public static final int CHAR_NUM = 1;
    public static final int TOKEN_LEN = 2;
    static final int ClassConflictBasicType = 1;
    static final int DuplicateClassName = 2;
    static final int DuplicateClassEnumName = 3;
    static final int EnumConflictBasicType = 4;
    static final int DuplicateEnumName = 5;
    static final int DuplicateEnumClassName = 6;
    static final int VoidConstant = 7;
    static final int VoidParamType = 8;
    static final int DuplicateVariable = 9;
    static final int DuplicateEnumChild = 10;
    static final int DuplicateFunction = 11;
    static final int DuplicateFunction_Builtin = 12;
    static final int ClassConstantError = 13;
    static final int IncompatibleTypes_ArrayIndex = 14;
    static final int IncompatibleTypes_Assignment = 15;
    static final int IncompatibleTypes_IfBoolean = 16;
    static final int IncompatibleTypes_WhileBoolean = 17;
    static final int IncompatibleTypes_ForBoolean = 18;
    static final int IncompatibleTypes_AssertBoolean = 19;
    static final int IncompatibleTypes_SwitchTopLevel = 20;
    static final int IncompatibleTypes_SwitchCaseLevel = 21;
    static final int IncompatibleTypes_Return = 22;
    static final int Return_MissingReturnValue = 23;
    static final int Return_ValueInVoid = 24;
    static final int Switch_EnumCaseExpected = 25;
    static final int Switch_DuplicateDefault = 26;
    static final int FunctionApplication_NoDots = 27;
    static final int FunctionApplication_Void = 28;
    static final int VariableDeclaration_Void = 29;
    static final int ArrayDeclaration_TooManyBraces = 30;
    static final int Binop_InvalidApplication = 31;
    static final int Unop_InvalidApplication = 32;
    static final int Incomparable = 33;
    static final int Array_TooManyAccesses = 34;
    static final int Lost_Variable = 35;
    static final int Lost_Class = 36;
    static final int Lost_Function = 37;
    static final int Lost_Function_Possible = 38;
    static final int BasicType_Dereference = 39;
    static final int Array_Dereference = 40;
    static final int TypeParam_Dereference = 41;
    static final int TypeParam_WithTypeParam = 42;
    static final int TypeParam_MisMatch = 43;
    static final int TypeParam_OnEnum = 44;
    static final int TypeParam_WithArrayBrackets = 45;
    static final int TypeParam_Duplicate = 46;
    static final int TypeParam_BasicType = 47;
    static final int VoidArrayType = 48;
    static final int Ambiguous_Function = 49;
    static final int Generic_Array_Creation = 50;
    static final int AssignToValue = 51;
    static final int AssignToConstant = 52;
    static final int UnopValuePP = 53;
    static final int UnopValueMM = 54;
    static final int UninitialisedVariable = 55;
    static final int Unreachable = 56;
    static final int SwitchNeedsConstant = 57;
    static final int IllegalBreakPlace = 58;
    static final int MissingReturnStatement = 59;
    static final int BadInt = 60;
    static final int BadDouble = 61;
    static final int InvalidEnumAssig = 62;
    static final int InvalidArrayLengthAssig = 63;
    static final int SwitchDuplicateLabel = 64;
    static final int PossibleLossOfPrecisionCharInt = 65;
    static final int TypeParamNoBindingFunction = 66;
    static final int VoidInAssert = 67;
    private int[] _errPos;
    private int[][] _linkPos;
    private String[] _messages;
    private final StringBuffer humanBuffer;
    private final StringBuffer javacBuffer;
    int _errID;
    private final Pattern linePattern = Pattern.compile("^(.+)[\n\r]*$", 8);

    public static SourceCodeException wrapParserException(ParserException pe) {
        String[] stringArray;
        int ln = pe.getToken().getLine();
        int pos = pe.getToken().getPos();
        Pattern p = Pattern.compile("\\[(\\d+),(\\d+)\\]");
        Matcher m = p.matcher(pe.getMessage());
        if (!m.find()) {
            throw new KenyaInternalError("Didn't match!" + pe.getMessage());
        }
        ln = Integer.parseInt(m.group(1));
        pos = Integer.parseInt(m.group(2));
        int len = pe.getToken().getText().trim().length();
        if (len == 0) {
            len = 1;
        }
        String entire = m.group(0);
        String mess = pe.getMessage().substring(entire.length());
        mess = mess.replaceAll(":", " one of:");
        mess = mess.replaceAll("'", "");
        mess = mess.replaceAll(" and", " &&");
        mess = mess.replaceAll(" or", " ||");
        mess = mess.replaceAll(" xor", " ^");
        mess = mess.replaceAll(" not", " !");
        mess = mess.replaceAll(" identifier", " <identifier>");
        mess = mess.replaceAll(" stringliteral", " <string>");
        mess = mess.replaceAll(" charliteral", " <character>");
        mess = mess.replaceAll(" bracket pair", " [ ]");
        mess = mess.replaceAll(" intnumber", " <integer>");
        mess = mess.replaceAll(" dpnumber", " <double>");
        if (pe.getToken().getText().trim().length() > 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = mess;
            stringArray = stringArray2;
            stringArray2[1] = "You have invalid syntax with this text: " + pe.getToken().getText().trim();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = mess;
            stringArray = stringArray3;
            stringArray3[1] = "You have invalid syntax";
        }
        String[] mess2 = stringArray;
        return new SourceCodeException(mess2, new int[]{ln, pos, len}, null, -1);
    }

    public static SourceCodeException wrapLexerException(LexerException le) {
        Pattern p = Pattern.compile("\\[(\\d+),(\\d+)\\]");
        Matcher m = p.matcher(le.getMessage());
        if (!m.find()) {
            throw new KenyaInternalError("m didn't match! " + le.getMessage());
        }
        int ln = Integer.parseInt(m.group(1));
        int pos = Integer.parseInt(m.group(2));
        String entire = m.group(0);
        String mess = le.getMessage().substring(entire.length());
        String[] mess2 = new String[]{mess, "You have invalid syntax"};
        return new SourceCodeException(mess2, new int[]{ln, pos, 1}, null, -1);
    }

    public static SourceCodeException noValidMainFunction() {
        String[] mess = new String[]{"Exception in thread \"main\" java.lang.NoSuchMethodError: main", "You need either a method void main(); or void main(String[] args)"};
        return new SourceCodeException(mess, new int[]{0, 0, 1}, null, -2);
    }

    public static SourceCodeException badClassName(ISourceCodeLocation pos, String name) {
        String[] mess = new String[]{"<none>", "The class name " + name + " is so commonly used in java that using it here will create a lot of confusion"};
        return new SourceCodeException(mess, new int[]{pos.getLineNumber(), pos.getColumnNumber(), pos.getTokenLength()}, null, -3);
    }

    public static SourceCodeException badClassBuiltinName(ISourceCodeLocation pos, String name) {
        String[] mess = new String[]{"<none>", "The class name " + name + " is is a reserved class name from one of the built-in methods you are using"};
        return new SourceCodeException(mess, new int[]{pos.getLineNumber(), pos.getColumnNumber(), pos.getTokenLength()}, null, -4);
    }

    public static SourceCodeException badEnumName(ISourceCodeLocation pos, String name) {
        String[] mess = new String[]{"<none>", "The enum name " + name + " is so commonly used in java that using it here will create a lot of confusion"};
        return new SourceCodeException(mess, new int[]{pos.getLineNumber(), pos.getColumnNumber(), pos.getTokenLength()}, null, -5);
    }

    public static SourceCodeException badEnumBuiltinName(ISourceCodeLocation pos, String name) {
        String[] mess = new String[]{"<none>", "The enum name " + name + " is a reserved class name from one of the built-in methods you are using"};
        return new SourceCodeException(mess, new int[]{pos.getLineNumber(), pos.getColumnNumber(), pos.getTokenLength()}, null, -6);
    }

    public static void throwClassConflictBasicType(int ln, int pos, int len, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("<identifier> expected");
        humanSB.append("You have tried to define a Class Type with a name which is reserved for Kenya's Basic Type ");
        humanSB.append(type);
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 1);
    }

    public static void throwDuplicateClassName(int ln, int pos, int len, int[][] linkPos, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("duplicate class: ");
        javacSB.append(type);
        humanSB.append("You have tried to define a Class Type with a name that is already defined as a Class Type");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 2);
    }

    public static void throwDuplicateClassEnumName(int ln, int pos, int len, int[][] linkPos, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("duplicate class: ");
        javacSB.append(type);
        humanSB.append("You have tried to define a Class Type with a name that is already defined as an Enum Type");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 3);
    }

    public static void throwEnumConflictBasicType(int ln, int pos, int len, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("<identifier> expected");
        humanSB.append("You have tried to define an Enum Type with a name which is reserved for Kenya's Basic Type ");
        humanSB.append(type);
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 4);
    }

    public static void throwDuplicateEnumName(int ln, int pos, int len, int[][] linkPos, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("duplicate class: ");
        javacSB.append(type);
        humanSB.append("You have tried to define an Enum Type with a name that is already defined as an Enum Type");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 5);
    }

    public static void throwDuplicateEnumClassName(int ln, int pos, int len, int[][] linkPos, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("duplicate class: ");
        javacSB.append(type);
        humanSB.append("You have tried to define an Enum Type with a name that is already defined as a Class Type");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 6);
    }

    public static void throwVoidConstant(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("'(' expected.");
        humanSB.append("You have tried to create a constant of type 'void'");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 7);
    }

    public static void throwVoidParamType(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("illegal start of type");
        humanSB.append("You have tried to create a class using 'void' as one of its parameter types");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 8);
    }

    public static void throwDuplicateVariable(int ln, int pos, int len, int[][] linkPos, String name, String scope) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append(name);
        javacSB.append(" is already defined in ");
        javacSB.append(scope);
        humanSB.append("You have tried to create a variable with the the name ( ");
        humanSB.append(name);
        humanSB.append(" ), but there is already a variable in this scope ( ");
        humanSB.append(scope);
        humanSB.append(" ) with that name");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 9);
    }

    public static void throwDuplicateEnumChild(int ln, int pos, int len, String name, String scope) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append(name);
        javacSB.append(" is already defined in ");
        javacSB.append(scope);
        humanSB.append("You have tried to create an enum constant with the same name as another enum constant in this enum declaration");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 10);
    }

    public static void throwDuplicateFunction(int ln, int pos, int len, int[][] linkPos, String name, String scope) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append(name);
        javacSB.append(" is already defined in ");
        javacSB.append(scope);
        humanSB.append("You have tried to declare a function which cannot be told apart from an existing function");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 11);
    }

    public static void throwDuplicateFunction_Builtin(int ln, int pos, int len, String name) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append(name);
        javacSB.append(" is already defined in <**Kenya Builtin Methods**>");
        humanSB.append("You have tried to declare a function which cannot be told apart from a Kenya built-in function");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 12);
    }

    public static void throwClassConstantError(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("<none>");
        humanSB.append("You have tried to declare a constant of Class Type, but Kenya only supports constants of Basic Type (boolean, char, int, double, String)");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 13);
    }

    public static void throwIncompatibleTypes_ArrayIndex(int ln, int pos, int len, KType rhs) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("incompatible types" + IJavaCode.NEWLINE + "found: ");
        javacSB.append(rhs);
        javacSB.append("" + IJavaCode.NEWLINE + "required: int");
        humanSB.append("You are trying to use a ");
        humanSB.append(rhs);
        humanSB.append(" type as an index into an array, however you can only index into an array with an expression of type int");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 14);
    }

    public static void throwIncompatibleTypes_Assignment(int ln, int pos, int len, KType lhs, KType rhs) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("incompatible types" + IJavaCode.NEWLINE + "found: ");
        javacSB.append(rhs);
        javacSB.append("" + IJavaCode.NEWLINE + "required: ");
        javacSB.append(lhs);
        humanSB.append("You are attempting an assignment operation, but have tried to assign an expression of type ");
        humanSB.append(rhs);
        humanSB.append(" to an expression of type ");
        humanSB.append(lhs);
        humanSB.append(". These two types are not 'assignment compatible'");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 15);
    }

    public static void throwIncompatibleTypes_IfBoolean(int ln, int pos, int len, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("incompatible types" + IJavaCode.NEWLINE + "found: ");
        javacSB.append(type);
        javacSB.append("" + IJavaCode.NEWLINE + "required: boolean");
        humanSB.append("You are attempting to use a ");
        humanSB.append(type);
        humanSB.append(" as the test in an if statement, however if statements can only test boolean expressions");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 16);
    }

    public static void throwIncompatibleTypes_WhileBoolean(int ln, int pos, int len, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("incompatible types" + IJavaCode.NEWLINE + "found: ");
        javacSB.append(type);
        javacSB.append("" + IJavaCode.NEWLINE + "required: boolean");
        humanSB.append("You are attempting to use a ");
        humanSB.append(type);
        humanSB.append(" as the test in a while loop, however while loops can only test boolean expressions");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 17);
    }

    public static void throwIncompatibleTypes_ForBoolean(int ln, int pos, int len, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("incompatible types" + IJavaCode.NEWLINE + "found: ");
        javacSB.append(type);
        javacSB.append("" + IJavaCode.NEWLINE + "required: boolean");
        humanSB.append("You are attempting to use a ");
        humanSB.append(type);
        humanSB.append(" as the test in a for loop, however for loops can only test boolean expressions");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 18);
    }

    public static void throwIncompatibleTypes_AssertBoolean(int ln, int pos, int len, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("incompatible types" + IJavaCode.NEWLINE + "found: ");
        javacSB.append(type);
        javacSB.append("" + IJavaCode.NEWLINE + "required: boolean");
        humanSB.append("You are attempting to use a ");
        humanSB.append(type);
        humanSB.append(" as the test in an assert statement, however assertions can only test boolean expressions");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 19);
    }

    public static void throwIncompatibleTypes_SwitchTopLevel(int ln, int pos, int len, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("incompatible types" + IJavaCode.NEWLINE + "found: ");
        javacSB.append(type);
        javacSB.append("" + IJavaCode.NEWLINE + "required: int");
        humanSB.append("You are attempting to switch on a ");
        humanSB.append(type);
        humanSB.append(", however in Kenya you can only switch on char, int, or enum type expressions");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 20);
    }

    public static void throwIncompatibleTypes_SwitchCaseLevel(int ln, int pos, int len, KType swType, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("incompatible types" + IJavaCode.NEWLINE + "found: ");
        javacSB.append(type);
        javacSB.append("" + IJavaCode.NEWLINE + "required: int");
        humanSB.append("You have a switch case of type ");
        humanSB.append(type);
        humanSB.append(" when the main switch itself is of type ");
        humanSB.append(swType);
        humanSB.append(", these are not compatible");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 21);
    }

    public static void throwIncompatibleTypes_Return(int ln, int pos, int len, KType returnValue, KType signatureValue) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("incompatible types" + IJavaCode.NEWLINE + "found: ");
        javacSB.append(returnValue);
        javacSB.append("" + IJavaCode.NEWLINE + "required: ");
        javacSB.append(signatureValue);
        humanSB.append("You are attempting to return a type of ");
        humanSB.append(returnValue);
        humanSB.append(" in a function that you have declared to be of type ");
        humanSB.append(signatureValue);
        humanSB.append(", these are not compatible");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 22);
    }

    public static void throwReturn_MissingReturnValue(int ln, int pos, int len, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("missing return value");
        humanSB.append("You are attempting to return from a function of type ");
        humanSB.append(type);
        humanSB.append(", but are not returning something of that type");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 23);
    }

    public static void throwReturn_ValueInVoid(int ln, int pos, int len, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("cannot return a value from a method whose return type is void");
        humanSB.append("You are attempting to return a value (of type ");
        humanSB.append(type);
        humanSB.append(") from a method that you have declared to be void (i.e. does not return anything)");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 24);
    }

    public static void throwSwitch_EnumCaseExpected(int ln, int pos, int len, KType swType) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("an enum switch case label must be the unqualified name of an enumeration constant");
        humanSB.append("You are switching on the enum type ");
        humanSB.append(swType);
        humanSB.append(", therefore all the case statements of this switch must be just the names of members of this enum");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 25);
    }

    public static void throwSwitch_DuplicateDefault(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("duplicate default label");
        humanSB.append("You have created a switch statement with multiple default labels, however a switch statement can only have one default label");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 26);
    }

    public static void throwFunctionApplication_NoDots(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("<none>");
        humanSB.append("Since Kenya does not support functions inside classes, there will never be a case where you will need a '.' to find them");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 27);
    }

    public static void throwFunctionApplication_Void(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("'void' type not allowed here");
        humanSB.append("You are attempting to call a function, but you are passing a void type in as one of the parameters");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 28);
    }

    public static void throwVariableDeclaration_Void(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("illegal start of expression");
        humanSB.append("You are attempting to create a variable of type 'void' ( what are you planning to do with it? :) )");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 29);
    }

    public static void throwArrayDeclaration_TooManyBraces(int ln, int pos, int len, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("illegal initialiser for ");
        javacSB.append(type);
        humanSB.append("You have braces in an array declaration going to too high a depth");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 30);
    }

    public static void throwBinop_InvalidApplication(int ln, int pos, int len, KType lhs, String name, KType rhs) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("operator ");
        javacSB.append(name);
        javacSB.append(" cannot be applied to ");
        javacSB.append(lhs);
        javacSB.append(",");
        javacSB.append(rhs);
        humanSB.append("You have tried to use the operator ");
        humanSB.append(name);
        humanSB.append(" in the form '");
        humanSB.append(lhs);
        humanSB.append(" ");
        humanSB.append(name);
        humanSB.append(" ");
        humanSB.append(rhs);
        humanSB.append("', which it cannot be used for");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 31);
    }

    public static void throwUnop_InvalidApplication(int ln, int pos, int len, String name, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("operator ");
        javacSB.append(name);
        javacSB.append(" cannot be applied to ");
        javacSB.append(type);
        humanSB.append("You have tried to use the unary operator ");
        humanSB.append(name);
        humanSB.append(" on a ");
        humanSB.append(type);
        humanSB.append(", this cannot be done");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 32);
    }

    public static void throwIncomparable(int ln, int pos, int len, KType lhs, String name, KType rhs) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("incomparable types: ");
        javacSB.append(lhs);
        javacSB.append(" and ");
        javacSB.append(rhs);
        humanSB.append("You have tried to compare a ");
        humanSB.append(lhs);
        humanSB.append(" with a ");
        humanSB.append(rhs);
        humanSB.append(", this cannot be done");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 33);
    }

    public static void throwArray_TooManyAccesses(int ln, int pos, int len, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("array required, but ");
        javacSB.append(type);
        javacSB.append(" found");
        humanSB.append("You have indexed into an array too many times");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 34);
    }

    public static void throwLost_Variable(int ln, int pos, int len, String name, String scope) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("cannot find symbol" + IJavaCode.NEWLINE + "symbol: ");
        javacSB.append(name);
        javacSB.append("  " + IJavaCode.NEWLINE + "location: ");
        javacSB.append(scope);
        humanSB.append("You are trying to reference a variable that isn't valid ( not declared / wrong scope / bad initialiser? )");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 35);
    }

    public static void throwLost_Class(int ln, int pos, int len, String name, String scope) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("cannot find symbol" + IJavaCode.NEWLINE + "symbol: ");
        javacSB.append(name);
        javacSB.append("  " + IJavaCode.NEWLINE + "location: ");
        javacSB.append(scope);
        humanSB.append("You are trying to reference a Class Type that hasn't been declared");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 36);
    }

    public static void throwLost_Function(int ln, int pos, int len, String args, String name, String scope) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("cannot find symbol" + IJavaCode.NEWLINE + "symbol: method ");
        javacSB.append(name);
        javacSB.append(args);
        javacSB.append(" " + IJavaCode.NEWLINE + "location: ");
        javacSB.append(scope);
        humanSB.append("You are trying to call a function that you have not declared, or is not a built in function");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 37);
    }

    public static void throwLost_Function_Possible(int ln, int pos, int len, int[][] linkPos, String args, String name, String scope) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("cannot find symbol" + IJavaCode.NEWLINE + "symbol: method ");
        javacSB.append(name);
        javacSB.append(args);
        javacSB.append(" " + IJavaCode.NEWLINE + "location: ");
        javacSB.append(scope);
        humanSB.append("You are trying to call a function that you have not declared, though it is possible you have the wrong types of parameters to this function call");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 38);
    }

    public static void throwBasicType_Dereference(int ln, int pos, int len, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append(type);
        javacSB.append(" cannot be dereferenced.");
        humanSB.append("You are attempting to apply a '.' to a ");
        humanSB.append(type);
        humanSB.append(", this cannot be done as Basic Types have no members");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 39);
    }

    public static void throwArray_Dereference(int ln, int pos, int len, String name, String scope) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("cannot find symbol" + IJavaCode.NEWLINE + "symbol: variable ");
        javacSB.append(name);
        javacSB.append(" " + IJavaCode.NEWLINE + "location: ");
        javacSB.append(scope);
        humanSB.append("You can only use a '.' on an array to access its length (with .length). You cannot use '.' on an array for any other purpose in Kenya");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 40);
    }

    public static void throwTypeParam_Dereference(int ln, int pos, int len, String name) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("cannot find symbol" + IJavaCode.NEWLINE + "symbol: variable ");
        javacSB.append(name);
        javacSB.append(" " + IJavaCode.NEWLINE + "location: class java.lang.Object");
        humanSB.append("You have tried to dereference a parameterised typed, but you cannot know (in Kenya) what their members could be");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 41);
    }

    public static void throwTypeParam_WithTypeParam(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("'>' expected");
        humanSB.append("A Type Parameter cannot have Type Parameters");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 42);
    }

    public static void throwTypeParam_MisMatch(int ln, int pos, int len, KClassType klass, int num) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("<possible> wrong number of type arguments; required ");
        javacSB.append(num);
        humanSB.append("This is not a valid reference to class ");
        humanSB.append(klass);
        humanSB.append(" as there is a mismatch with its Type Parameters");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 43);
    }

    public static void throwTypeParam_OnEnum(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("'{' expected");
        humanSB.append("An enum declaration cannot have Type Parameters");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 44);
    }

    public static void throwTypeParam_WithArrayBrackets(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("'>' expected");
        humanSB.append("A Type Parameter cannot have array index brackets attached to it");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 45);
    }

    public static void throwTypeParam_Duplicate(int ln, int pos, int len, String name, String scope) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append(name);
        javacSB.append(" is already defined in ");
        javacSB.append(scope);
        humanSB.append("You have duplicate Type Parameters with the name ");
        humanSB.append(name);
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 46);
    }

    public static void throwTypeParam_BasicType(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("< identifier > expected");
        humanSB.append("You cannot use the name of a Basic Type as a Type Parameter");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 47);
    }

    public static void throwVoidArrayType(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("'void' type not allowed here");
        humanSB.append("You are trying to make a void array, what are you going to store in it? :)");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 48);
    }

    public static void throwAmbiguous_Function(int ln, int pos, int len, int[][] linkPos, String argType1, String argType2, String global, String name) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("reference to ");
        javacSB.append(name);
        javacSB.append(" is ambiguous, both method ");
        javacSB.append(name);
        javacSB.append(argType1);
        javacSB.append(" in ");
        javacSB.append(global);
        javacSB.append(" and method ");
        javacSB.append(name);
        javacSB.append(argType2);
        javacSB.append(" in ");
        javacSB.append(global);
        javacSB.append(" match");
        humanSB.append("You are calling a function, however there are several that match and Kenya isn't sure which one you mean");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 49);
    }

    public static void throwGeneric_Array_Creation(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("generic array creation");
        humanSB.append("You cannot create arrays which are of a Parameterized Type");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 50);
    }

    public static void throwAssignToValue(int ln, int pos, int len, String val) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("unexpected type" + IJavaCode.NEWLINE + "required: variable " + IJavaCode.NEWLINE + "found: value");
        humanSB.append("You have tried to assign a value ( ");
        humanSB.append(val);
        humanSB.append(" ) to something new");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 51);
    }

    public static void throwAssignToConstant(int ln, int pos, int len, int[][] linkPos, KVariable name) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("cannot assign a value to final variable ");
        javacSB.append(name);
        humanSB.append("You have tried to assign a constant variable a new value ( think about it... )");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 52);
    }

    public static void throwUnopValuePP(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("unexpected type" + IJavaCode.NEWLINE + "required: variable " + IJavaCode.NEWLINE + "found: value");
        humanSB.append("You cannot apply ++ to a non-variable.");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 53);
    }

    public static void throwUnopValueMM(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("unexpected type" + IJavaCode.NEWLINE + "required: variable " + IJavaCode.NEWLINE + "found: value");
        humanSB.append("You cannot apply -- to a non-variable.");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 54);
    }

    public static void throwUninitialisedVariable(int ln, int pos, int len, int[][] linkPos, String name) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("variable ");
        javacSB.append(name);
        javacSB.append(" might not have been initialised");
        humanSB.append("You are trying to use a variable that it is possible you have not given a value to yet");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 55);
    }

    public static void throwUnreachable(int ln, int pos, int len, int[][] linkPos) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("unreachable statement");
        humanSB.append("This statement cannot be executed or reached");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 56);
    }

    public static void throwSwitchNeedsConstant(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("constant expression required");
        humanSB.append("The cases for a switch statement all have to be constants at compile time, this expression is not constant");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 57);
    }

    public static void throwIllegalBreakPlace(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("break outside switch or loop");
        humanSB.append("You can only place break statements inside switch statements and while or for loops");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 58);
    }

    public static void throwMissingReturnStatement(int ln, int pos, int len, int[][] linkPos, KType type) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("missing return statement");
        humanSB.append("This function needs to return a variable of type ");
        humanSB.append(type);
        humanSB.append(", but not all paths through the function return a variable of that type");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 59);
    }

    public static void throwBadInt(int ln, int pos, int len, String num) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("integer number too large: ");
        javacSB.append(num);
        humanSB.append("This is not a valid number for an int. ( ints can be between -2147483648 and 2147483647 )");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 60);
    }

    public static void throwBadDouble(int ln, int pos, int len, String num) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("floating point number too large: ");
        javacSB.append(num);
        humanSB.append("This is not a valid number for a double. ( doubles can be between roughly +/- 1.7976931348623157E308 )");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 61);
    }

    public static void throwInvalidEnumAssig(int ln, int pos, int len, String name) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("cannot assign a value to final variable ");
        javacSB.append(name);
        humanSB.append("You cannot assign to an enum constant");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 62);
    }

    public static void throwInvalidArrayLengthAssig(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("cannot assign a value to final variable length");
        humanSB.append("You cannot assign to the length of an array.");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 63);
    }

    public static void throwSwitchDuplicateLabel(int ln, int pos, int len, int[][] linkPos) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("duplicate case label");
        humanSB.append("You have defined a switch case that is the same as another switch case");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 64);
    }

    public static void throwPossibleLossOfPrecisionCharInt(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("possible loss of precision" + IJavaCode.NEWLINE + "required: char " + IJavaCode.NEWLINE + "found: int");
        humanSB.append("You are assigning a char variable with something that *could* be of int type");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 65);
    }

    public static void throwTypeParamNoBindingFunction(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("<none applicable>");
        humanSB.append("You are defining a function where its return type is never specified by the parameters to this function");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 66);
    }

    public static void throwVoidInAssert(int ln, int pos, int len) {
        StringBuffer javacSB = new StringBuffer();
        StringBuffer humanSB = new StringBuffer();
        javacSB.append("'void' type not allowed here");
        humanSB.append("An assert message cannot be of void type");
        String[] out = new String[]{javacSB.toString(), humanSB.toString()};
        int[][] linkPos = null;
        int[] errPos = new int[]{ln, pos, len};
        throw new SourceCodeException(out, errPos, linkPos, 67);
    }

    SourceCodeException(String[] messages, int[] errPos, int[][] linkPos, int errID) {
        this._messages = messages;
        this._errPos = errPos;
        this._linkPos = linkPos;
        this._errID = errID;
        StringWriter sWriter = new StringWriter();
        PrintWriter pwriter = new PrintWriter(sWriter);
        Matcher m = this.linePattern.matcher(this._messages[1]);
        boolean first = true;
        while (m.find()) {
            if (first) {
                first = false;
            } else {
                pwriter.println();
            }
            pwriter.print(m.group());
        }
        this.humanBuffer = sWriter.getBuffer();
        sWriter = new StringWriter();
        pwriter = new PrintWriter(sWriter);
        m = this.linePattern.matcher(this._messages[0]);
        first = true;
        while (m.find()) {
            if (first) {
                first = false;
            } else {
                pwriter.println();
            }
            pwriter.print(m.group(1));
        }
        this.javacBuffer = sWriter.getBuffer();
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getErrorLocation());
        sb.append(this.getLinkLocations());
        sb.append(IJavaCode.NEWLINE);
        sb.append(this.javacBuffer);
        sb.append(IJavaCode.NEWLINE);
        sb.append(this.humanBuffer);
        sb.append(IJavaCode.NEWLINE);
        sb.append("{ ");
        sb.append(this._errID);
        sb.append(" }");
        return sb.toString();
    }

    public StringReader getJavacStyleMessage() {
        return new StringReader(this.javacBuffer.toString());
    }

    public StringReader getHumanStyleMessage() {
        return new StringReader(this.humanBuffer.toString());
    }

    public String getErrorLocation() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this._errPos[0]);
        sb.append(",");
        sb.append(this._errPos[1]);
        sb.append("]");
        return sb.toString();
    }

    public String getLinkLocations() {
        if (this._linkPos == null || this._linkPos.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this._linkPos.length; ++i) {
            sb.append(" ");
            sb.append("[");
            sb.append(this._linkPos[i][0]);
            sb.append(",");
            sb.append(this._linkPos[i][1]);
            sb.append("]");
        }
        sb.append(" )");
        return sb.toString();
    }

    public ISourceCodeLocation getLocation() {
        return new SourceCodeLocation(this._errPos[0], this._errPos[1], this._errPos[2]);
    }

    public ISourceCodeLocation[] getLinkedInformation() {
        if (this._linkPos == null) {
            return new ISourceCodeLocation[0];
        }
        ISourceCodeLocation[] out = new ISourceCodeLocation[this._linkPos.length];
        for (int i = 0; i < this._linkPos.length; ++i) {
            out[i] = new SourceCodeLocation(this._linkPos[i][0], this._linkPos[i][1], this._linkPos[i][2]);
        }
        return out;
    }

    public int getInformationNumber() {
        return this._errID;
    }
}

