/*
 * Decompiled with CFR 0.152.
 */
package kenya.passes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kenya.errors.ExceptionMapperWrapper;
import kenya.errors.KenyaPreconditionError;
import kenya.errors.SourceCodeException;
import kenya.passes.StructureChecker;
import kenya.passes.Util;
import kenya.types.KBasicType;
import kenya.types.KVariable;
import kenya.types.tables.ClassTable;
import kenya.types.tables.FunctionTable;
import kenya.types.tables.SymbolTable;
import kenya.types.tables.VariableTable;
import kenya.values.IKNumericValue;
import kenya.values.IKValue;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.ABasicTypeType;
import minijava.node.AClassDecDeclaration;
import minijava.node.AConstDecDeclaration;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AFuncDecDeclaration;
import minijava.node.Start;

public final class RestrictedStructureChecker
extends DepthFirstAdapter {
    private VariableTable _varTab = new VariableTable();
    private SymbolTable _symTab = new SymbolTable();
    private Map _typeMap;
    private List _errors;
    private List _infos;
    private Set _errNodes;
    private Set _arrayLengths;
    private Set _enumChildSet;

    private RestrictedStructureChecker(Map typeMap, Set errNodes, Set arrayLengths, Set enumChildSet) {
        this._typeMap = typeMap;
        this._errNodes = errNodes;
        this._symTab.newLocalScope();
        this._infos = new LinkedList();
        this._errors = new LinkedList();
        this._arrayLengths = arrayLengths;
        this._enumChildSet = enumChildSet;
    }

    public static final VariableTable processConstants(Start ast, Map typeMap, Set errNodes, Set arrayLengths, Set enumChildSet, List infos, List errors) {
        RestrictedStructureChecker rsc = new RestrictedStructureChecker(typeMap, errNodes, arrayLengths, enumChildSet);
        ast.apply(rsc);
        infos.addAll(rsc._infos);
        errors.addAll(rsc._errors);
        return rsc.getVariableTable();
    }

    public VariableTable getVariableTable() {
        return this._varTab;
    }

    public void caseAConstDecDeclaration(AConstDecDeclaration node) {
        if (this._errNodes.contains(node)) {
            return;
        }
        this.inAConstDecDeclaration(node);
        StructureChecker sc = new StructureChecker(new ClassTable(), this._symTab, new FunctionTable(), this._varTab, new HashSet(), this._typeMap, new HashMap(), this._arrayLengths, this._enumChildSet);
        try {
            KVariable kv;
            node.getInitialiser().apply(sc);
            IKValue ikv = sc.getTopOfValueStack();
            KBasicType type = Util.getBasicType((ABasicTypeType)node.getType());
            String ident = node.getIdentifier().getText().trim();
            if (type == KBasicType.getChar()) {
                if (ikv instanceof IKNumericValue) {
                    IKNumericValue iknv = (IKNumericValue)ikv;
                    if (!iknv.inCharRange()) {
                        int[] pos = Util.getFirstIdent(node.getInitialiser());
                        SourceCodeException.throwPossibleLossOfPrecisionCharInt(pos[0], pos[1], pos[2]);
                    }
                } else if (!Util.isSingleVariableExpression(node.getInitialiser())) {
                    int[] pos = Util.getFirstIdent(node.getInitialiser());
                    SourceCodeException.throwPossibleLossOfPrecisionCharInt(pos[0], pos[1], pos[2]);
                }
            }
            if (!this._symTab.pushLocal(ident, kv = new KVariable(ident, type, true, node))) {
                throw KenyaPreconditionError.get();
            }
            if (!this._varTab.addConstant(kv, ikv)) {
                throw KenyaPreconditionError.get();
            }
        }
        catch (SourceCodeException sce) {
            this._errors.add(ExceptionMapperWrapper.wrapConstantException(sce));
            this._errNodes.add(node);
        }
        this._infos.addAll(sc.getInfos());
        this.outAConstDecDeclaration(node);
    }

    public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
    }

    public void caseAClassDecDeclaration(AClassDecDeclaration node) {
    }

    public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {
    }
}

