/*
 * Decompiled with CFR 0.152.
 */
package kenya.passes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kenya.errors.KenyaInternalError;
import kenya.errors.KenyaPreconditionError;
import kenya.errors.SourceCodeException;
import kenya.passes.SingleVariableExpressionChecker;
import kenya.passes.TokenPositionFinder;
import kenya.types.KArrayType;
import kenya.types.KBasicType;
import kenya.types.KBoundClassType;
import kenya.types.KClassType;
import kenya.types.KEnumType;
import kenya.types.KFunction;
import kenya.types.KNullType;
import kenya.types.KParamType;
import kenya.types.KType;
import kenya.types.KVariable;
import kenya.types.tables.ClassTable;
import kenya.types.tables.TypeTable;
import minijava.node.ABasicTypeType;
import minijava.node.ABooleanBasicType;
import minijava.node.ACharBasicType;
import minijava.node.ACharliteralFactor;
import minijava.node.AClassTypeReferenceType;
import minijava.node.ACommaType;
import minijava.node.ACommaTypeName;
import minijava.node.ADoubleBasicType;
import minijava.node.AFormalParamList;
import minijava.node.AFuncDecDeclaration;
import minijava.node.AIntBasicType;
import minijava.node.AReferenceTypeType;
import minijava.node.AStringBasicType;
import minijava.node.ATypeName;
import minijava.node.ATypeParam;
import minijava.node.ATypeParamList;
import minijava.node.AVoidBasicType;
import minijava.node.Node;
import minijava.node.PBasicType;
import minijava.node.PType;
import minijava.node.PTypeName;
import minijava.node.TBracketPair;

public class Util {
    public static final String GLOBAL = "<global>";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static KType getType(PType type, ClassTable ct, Map paramTypes, int numBrackets, String cScope) {
        if (type instanceof ABasicTypeType) {
            KBasicType kBasicType = Util.getBasicType((ABasicTypeType)type);
        } else {
            if (!(type instanceof AReferenceTypeType)) {
                throw new KenyaInternalError("Got a type that isn't Reference or Basic!" + type);
            }
            AClassTypeReferenceType actrt = (AClassTypeReferenceType)((AReferenceTypeType)type).getReferenceType();
            String ident = actrt.getIdentifier().getText().trim();
            if (paramTypes.containsKey(ident)) {
                if (actrt.getTypeParam() != null) {
                    int ln = ((ATypeParam)actrt.getTypeParam()).getLess().getLine();
                    int pos = ((ATypeParam)actrt.getTypeParam()).getLess().getPos();
                    int len = ((ATypeParam)actrt.getTypeParam()).getLess().getText().trim().length();
                    SourceCodeException.throwTypeParam_WithTypeParam(ln, pos, len);
                    return null;
                }
                KType kType = (KType)paramTypes.get(ident);
            } else {
                if (!ct.containsMapping(ident)) {
                    int ln = actrt.getIdentifier().getLine();
                    int pos = actrt.getIdentifier().getPos();
                    int len = actrt.getIdentifier().getText().trim().length();
                    SourceCodeException.throwLost_Class(ln, pos, len, ident, cScope);
                    return null;
                }
                if (ct.isClass(ident)) {
                    List params;
                    KClassType kc = (KClassType)ct.getType(ident);
                    if (!kc.doTypeParametersMatch(params = Util.getTypeParamList(actrt, ct, paramTypes, cScope))) {
                        int ln = actrt.getIdentifier().getLine();
                        int pos = actrt.getIdentifier().getPos();
                        int len = actrt.getIdentifier().getText().trim().length();
                        SourceCodeException.throwTypeParam_MisMatch(ln, pos, len, kc, kc.getTypeParamList().size());
                        return null;
                    }
                    TypeTable tt = kc.genTypeTable(params);
                    KBoundClassType kBoundClassType = new KBoundClassType(kc, tt);
                } else {
                    if (!ct.containsMapping(ident)) {
                        throw new KenyaInternalError("Got a type that is in the known types, but isn't a class, or an enum type!");
                    }
                    if (actrt.getTypeParam() != null) {
                        int ln = ((ATypeParam)actrt.getTypeParam()).getLess().getLine();
                        int pos = ((ATypeParam)actrt.getTypeParam()).getLess().getPos();
                        int len = ((ATypeParam)actrt.getTypeParam()).getLess().getText().trim().length();
                        SourceCodeException.throwTypeParam_OnEnum(ln, pos, len);
                        return null;
                    }
                    KType kType = ct.getType(ident);
                }
            }
        }
        int i = 0;
        void var5_11;
        while (i < numBrackets) {
            if (var5_11 == KBasicType.getVoid()) {
                int[] pos = Util.getFirstIdent(type);
                SourceCodeException.throwVoidArrayType(pos[0], pos[1], pos[2]);
            }
            KArrayType kArrayType = new KArrayType((KType)var5_11);
            ++i;
        }
        return var5_11;
    }

    static char parseCharacter(ACharliteralFactor node) {
        char c;
        int end;
        String text = node.getCharliteral().getText();
        int start = text.indexOf("'");
        if ((text = text.substring(start + 1, end = text.lastIndexOf("'"))).length() != 1) {
            if (text.charAt(0) != '\\') {
                throw new KenyaInternalError("Impossible");
            }
            char tmp = text.charAt(1);
            c = Util.escapeOneChar(tmp);
        } else {
            c = text.charAt(0);
        }
        return c;
    }

    private static char escapeOneChar(char in) {
        char c;
        switch (in) {
            case '0': {
                c = '\u0000';
                break;
            }
            case 'b': {
                c = '\b';
                break;
            }
            case 't': {
                c = '\t';
                break;
            }
            case 'n': {
                c = '\n';
                break;
            }
            case 'f': {
                c = '\f';
                break;
            }
            case 'r': {
                c = '\r';
                break;
            }
            case '\"': {
                c = '\"';
                break;
            }
            case '\'': {
                c = '\'';
                break;
            }
            case '\\': {
                c = '\\';
                break;
            }
            default: {
                throw new KenyaInternalError("Impossible");
            }
        }
        return c;
    }

    static String escapeString(String unescaped) {
        StringBuffer sb = new StringBuffer(unescaped);
        StringBuffer out = new StringBuffer();
        boolean escapeMode = false;
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (escapeMode) {
                c = Util.escapeOneChar(c);
                out.append(c);
                escapeMode = false;
                continue;
            }
            if (c == '\\') {
                escapeMode = true;
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    static List getTypeParamList(PType type, ClassTable ct, Map paramTypes, String cScope) {
        if (!(type instanceof AReferenceTypeType)) {
            return new LinkedList();
        }
        AClassTypeReferenceType actrt = (AClassTypeReferenceType)((AReferenceTypeType)type).getReferenceType();
        String ident = actrt.getIdentifier().getText().trim();
        if (!ct.isClass(ident)) {
            return new LinkedList();
        }
        return Util.getTypeParamList(actrt, ct, paramTypes, cScope);
    }

    static List getTypeParamList(AClassTypeReferenceType actrt, ClassTable ct, Map paramTypes, String cScope) {
        if (actrt.getTypeParam() == null) {
            return new LinkedList();
        }
        ATypeParamList atpl = (ATypeParamList)((ATypeParam)actrt.getTypeParam()).getTypeParamList();
        return Util.getTypeParamList(atpl, ct, paramTypes, cScope);
    }

    public static int[] getFirstIdent(Node node) {
        return TokenPositionFinder.find(node);
    }

    static List getTypeParamList(ATypeParamList atpl, ClassTable ct, Map paramTypes, String cScope) {
        LinkedList<KType> l = new LinkedList<KType>();
        int numBrackets = atpl.getBracketPair() != null ? atpl.getBracketPair().size() : 0;
        KType otype = Util.getType(atpl.getType(), ct, paramTypes, numBrackets, cScope);
        if (otype instanceof KBasicType && otype != KBasicType.getVoid() && otype != KBasicType.getString()) {
            l.add(new KBoundClassType(((KBasicType)otype).getClassType(), new TypeTable()));
        } else if (otype == KBasicType.getVoid()) {
            int[] pos = Util.getFirstIdent(atpl.getType());
            SourceCodeException.throwVoidParamType(pos[0], pos[1], pos[2]);
        } else {
            l.add(otype);
        }
        LinkedList commaList = atpl.getCommaType();
        if (commaList != null) {
            for (ACommaType act : commaList) {
                numBrackets = act.getBracketPair() != null ? act.getBracketPair().size() : 0;
                KType type = Util.getType(act.getType(), ct, paramTypes, numBrackets, cScope);
                if (type instanceof KBasicType && type != KBasicType.getVoid() && type != KBasicType.getString()) {
                    l.add(type.bind(new TypeTable()));
                    continue;
                }
                if (type == KBasicType.getVoid()) {
                    int[] pos = Util.getFirstIdent(act.getType());
                    SourceCodeException.throwVoidParamType(pos[0], pos[1], pos[2]);
                    continue;
                }
                l.add(type);
            }
        }
        return l;
    }

    static boolean isBasicArray(KType check) {
        if (check instanceof KBasicType) {
            return true;
        }
        if (check instanceof KArrayType) {
            KArrayType kat = (KArrayType)check;
            KType child = kat.getBaseType();
            return child instanceof KBasicType;
        }
        return false;
    }

    static KBasicType getBasicType(ABasicTypeType type) {
        PBasicType bt = type.getBasicType();
        if (bt instanceof ACharBasicType) {
            return KBasicType.getChar();
        }
        if (bt instanceof AIntBasicType) {
            return KBasicType.getInt();
        }
        if (bt instanceof ADoubleBasicType) {
            return KBasicType.getDouble();
        }
        if (bt instanceof AStringBasicType) {
            return KBasicType.getString();
        }
        if (bt instanceof ABooleanBasicType) {
            return KBasicType.getBoolean();
        }
        if (bt instanceof AVoidBasicType) {
            return KBasicType.getVoid();
        }
        throw new KenyaInternalError("Got a Basic type that isn't known;" + type.toString());
    }

    static KFunction makeFunction(AFuncDecDeclaration fdd, ClassTable ct) {
        HashMap<String, KType> paramMap = new HashMap<String, KType>();
        if (fdd.getTypeParam() != null && ((ATypeParam)fdd.getTypeParam()).getTypeParamList() != null) {
            List paramList = Util.getParameterTemplates((ATypeParamList)((ATypeParam)fdd.getTypeParam()).getTypeParamList(), fdd.getIdentifier().getText().trim());
            for (KType type : paramList) {
                String name = type.toString();
                paramMap.put(name, type);
            }
        }
        int numBrackets = fdd.getBracketPair() == null ? 0 : fdd.getBracketPair().size();
        KType retType = Util.getType(fdd.getType(), ct, paramMap, numBrackets, GLOBAL);
        String fnName = fdd.getIdentifier().getText().trim();
        if (fdd.getFormalParamList() == null) {
            if (retType.isBound(new HashMap())) {
                return new KFunction(fnName, paramMap, retType, null, null, null, fdd);
            }
            int[] pos = Util.getFirstIdent(fdd.getIdentifier());
            SourceCodeException.throwTypeParamNoBindingFunction(pos[0], pos[1], pos[2]);
        }
        HashMap<String, PTypeName> varIdents = new HashMap<String, PTypeName>();
        LinkedList<KVariable> vars = new LinkedList<KVariable>();
        LinkedList<KType> args = new LinkedList<KType>();
        HashMap refdTypeMap = new HashMap();
        AFormalParamList afpl = (AFormalParamList)fdd.getFormalParamList();
        numBrackets = ((ATypeName)afpl.getTypeName()).getBracketPair() == null ? 0 : ((ATypeName)afpl.getTypeName()).getBracketPair().size();
        KType kt = Util.getType(((ATypeName)afpl.getTypeName()).getType(), ct, paramMap, numBrackets, fnName);
        kt.populateParamMap(refdTypeMap);
        String ident = ((ATypeName)afpl.getTypeName()).getIdentifier().getText().trim();
        vars.add(new KVariable(ident, kt, false, afpl.getTypeName()));
        args.add(kt);
        varIdents.put(ident, afpl.getTypeName());
        if (afpl.getCommaTypeName() == null) {
            if (retType.isBound(refdTypeMap)) {
                return new KFunction(fnName, paramMap, retType, args, vars, null, fdd);
            }
            int[] pos = Util.getFirstIdent(fdd.getIdentifier());
            SourceCodeException.throwTypeParamNoBindingFunction(pos[0], pos[1], pos[2]);
        }
        for (ACommaTypeName actn : afpl.getCommaTypeName()) {
            numBrackets = ((ATypeName)actn.getTypeName()).getBracketPair() == null ? 0 : ((ATypeName)actn.getTypeName()).getBracketPair().size();
            kt = Util.getType(((ATypeName)actn.getTypeName()).getType(), ct, paramMap, numBrackets, fnName);
            kt.populateParamMap(refdTypeMap);
            ident = ((ATypeName)actn.getTypeName()).getIdentifier().getText().trim();
            if (varIdents.containsKey(ident)) {
                int ln = ((ATypeName)actn.getTypeName()).getIdentifier().getLine();
                int pos = ((ATypeName)actn.getTypeName()).getIdentifier().getPos();
                int len = ((ATypeName)actn.getTypeName()).getIdentifier().getText().trim().length();
                int oln = ((ATypeName)varIdents.get(ident)).getIdentifier().getLine();
                int opos = ((ATypeName)varIdents.get(ident)).getIdentifier().getPos();
                int olen = ((ATypeName)varIdents.get(ident)).getIdentifier().getText().trim().length();
                int[][] lnkPos = new int[][]{{oln, opos, olen}};
                SourceCodeException.throwDuplicateVariable(ln, pos, len, lnkPos, ident, fnName);
            }
            varIdents.put(ident, actn.getTypeName());
            vars.add(new KVariable(ident, kt, false, actn.getTypeName()));
            args.add(kt);
        }
        if (retType.isBound(refdTypeMap)) {
            return new KFunction(fnName, paramMap, retType, args, vars, null, fdd);
        }
        int[] pos = Util.getFirstIdent(fdd.getIdentifier());
        SourceCodeException.throwTypeParamNoBindingFunction(pos[0], pos[1], pos[2]);
        return null;
    }

    static KParamType mkParamType(PType pt) {
        if (pt instanceof ABasicTypeType) {
            int[] pos = Util.getFirstIdent(pt);
            SourceCodeException.throwTypeParam_BasicType(pos[0], pos[1], pos[2]);
            return null;
        }
        if (pt instanceof AReferenceTypeType) {
            AClassTypeReferenceType actrt = (AClassTypeReferenceType)((AReferenceTypeType)pt).getReferenceType();
            if (actrt.getTypeParam() != null) {
                int ln = ((ATypeParam)actrt.getTypeParam()).getLess().getLine();
                int pos = ((ATypeParam)actrt.getTypeParam()).getLess().getPos();
                int len = ((ATypeParam)actrt.getTypeParam()).getLess().getText().trim().length();
                SourceCodeException.throwTypeParam_WithTypeParam(ln, pos, len);
            }
            return new KParamType(actrt.getIdentifier().getText().trim(), actrt.getIdentifier());
        }
        throw KenyaPreconditionError.get();
    }

    static List getParameterTemplates(ATypeParamList atpl, String cScope) {
        PType pt;
        KParamType res;
        int len;
        int pos;
        int ln;
        LinkedList<KParamType> l = new LinkedList<KParamType>();
        HashSet<String> s = new HashSet<String>();
        if (atpl.getBracketPair() != null && atpl.getBracketPair().size() != 0) {
            ln = ((TBracketPair)atpl.getBracketPair().get(0)).getLine();
            pos = ((TBracketPair)atpl.getBracketPair().get(0)).getPos();
            len = ((TBracketPair)atpl.getBracketPair().get(0)).getText().trim().length();
            SourceCodeException.throwTypeParam_WithArrayBrackets(ln, pos, len);
        }
        if (!s.add((res = Util.mkParamType(pt = atpl.getType())).toString())) {
            ln = ((AClassTypeReferenceType)((AReferenceTypeType)atpl.getType()).getReferenceType()).getIdentifier().getLine();
            pos = ((AClassTypeReferenceType)((AReferenceTypeType)atpl.getType()).getReferenceType()).getIdentifier().getPos();
            len = ((AClassTypeReferenceType)((AReferenceTypeType)atpl.getType()).getReferenceType()).getIdentifier().getText().trim().length();
            SourceCodeException.throwTypeParam_Duplicate(ln, pos, len, res.toString(), cScope);
        }
        l.add(res);
        for (ACommaType act : atpl.getCommaType()) {
            int len2;
            int pos2;
            int ln2;
            if (act.getBracketPair() != null && act.getBracketPair().size() != 0) {
                ln2 = ((TBracketPair)act.getBracketPair().get(0)).getLine();
                pos2 = ((TBracketPair)act.getBracketPair().get(0)).getPos();
                len2 = ((TBracketPair)act.getBracketPair().get(0)).getText().trim().length();
                SourceCodeException.throwTypeParam_WithArrayBrackets(ln2, pos2, len2);
            }
            if (!s.add((res = Util.mkParamType(pt = act.getType())).toString())) {
                ln2 = ((AClassTypeReferenceType)((AReferenceTypeType)pt).getReferenceType()).getIdentifier().getLine();
                pos2 = ((AClassTypeReferenceType)((AReferenceTypeType)pt).getReferenceType()).getIdentifier().getPos();
                len2 = ((AClassTypeReferenceType)((AReferenceTypeType)pt).getReferenceType()).getIdentifier().getText().trim().length();
                SourceCodeException.throwTypeParam_Duplicate(ln2, pos2, len2, res.toString(), cScope);
            }
            l.add(res);
        }
        return l;
    }

    static boolean isSingleVariableExpression(Node pexp) {
        return SingleVariableExpressionChecker.isSingleVariableExpression(pexp);
    }

    public static boolean isAssignmentCompatible(KType a, KType b) {
        if (a == KBasicType.getVoid()) {
            return false;
        }
        if (a == b) {
            return true;
        }
        if (a instanceof KArrayType) {
            if (b instanceof KArrayType) {
                KArrayType kat = (KArrayType)a;
                KArrayType kbt = (KArrayType)b;
                KType childA = kat.getChildType();
                KType childB = kbt.getChildType();
                if (childA instanceof KBasicType && childB instanceof KBasicType) {
                    return childA == childB;
                }
                if (childA instanceof KBasicType && childB instanceof KBoundClassType) {
                    return false;
                }
                if (childA instanceof KBoundClassType && childB instanceof KBasicType) {
                    return false;
                }
                if (childA instanceof KBoundClassType && childB instanceof KBoundClassType) {
                    KBoundClassType kbA = (KBoundClassType)childA;
                    KBoundClassType kbB = (KBoundClassType)childB;
                    if (kbA.getBase() != kbB.getBase()) {
                        return false;
                    }
                }
                return Util.isAssignmentCompatible(childA, childB);
            }
            return b instanceof KNullType;
        }
        if (a instanceof KBasicType) {
            if (a == KBasicType.getString()) {
                return b == KBasicType.getString() || b == KNullType.get();
            }
            if (b instanceof KBasicType) {
                return a == KBasicType.getDouble() && (b == KBasicType.getInt() || b == KBasicType.getChar()) || a == KBasicType.getInt() && b == KBasicType.getChar();
            }
            if (b instanceof KBoundClassType) {
                KBoundClassType kbB = (KBoundClassType)b;
                return Util.isAssignmentCompatible(a, kbB.getBase());
            }
            if (b instanceof KClassType) {
                return a == KBasicType.getDouble() && (b == KClassType.getInteger() || b == KClassType.getCharacter()) || a == KBasicType.getInt() && b == KClassType.getCharacter() || a == KBasicType.getBoolean() && b == KClassType.getBoolean() || a == KBasicType.getChar() && b == KClassType.getCharacter() || a == KBasicType.getInt() && b == KClassType.getInteger() || a == KBasicType.getDouble() && b == KClassType.getDouble();
            }
            return false;
        }
        if (a instanceof KBoundClassType) {
            KBoundClassType kbA = (KBoundClassType)a;
            if (b instanceof KBoundClassType) {
                KBoundClassType kbB = (KBoundClassType)b;
                if (!Util.isAssignmentCompatible(kbA.getBase(), kbB.getBase())) {
                    return false;
                }
                boolean isOk = true;
                List params = kbA.getBase().getTypeParamList();
                TypeTable ttA = kbA.getBindings();
                TypeTable ttB = kbB.getBindings();
                for (KParamType kpt : params) {
                    KType cA = ttA.lookup(kpt);
                    KType cB = ttB.lookup(kpt);
                    isOk &= Util.isAssignmentCompatible(cA, cB);
                }
                return isOk;
            }
            if (b instanceof KBasicType) {
                return Util.isAssignmentCompatible(kbA.getBase(), b);
            }
            return b instanceof KNullType;
        }
        if (a instanceof KClassType) {
            if (b instanceof KClassType) {
                return a.getName().equals(b.getName());
            }
            if (b instanceof KBasicType) {
                return a == KClassType.getBoolean() && b == KBasicType.getBoolean() || a == KClassType.getCharacter() && b == KBasicType.getChar() || a == KClassType.getInteger() && b == KBasicType.getInt() || a == KClassType.getDouble() && b == KBasicType.getDouble();
            }
            return false;
        }
        if (a instanceof KEnumType) {
            if (b instanceof KEnumType) {
                return b.getName().equals(a.getName());
            }
            return b instanceof KNullType;
        }
        if (a instanceof KParamType) {
            if (b instanceof KNullType) {
                return true;
            }
            if (b instanceof KParamType) {
                return b.getName().equals(a.getName());
            }
            return false;
        }
        if (a instanceof KNullType) {
            return false;
        }
        throw new KenyaInternalError("Got an unknown type " + a);
    }
}

