/*
 * Decompiled with CFR 0.152.
 */
package kenya.types;

import java.util.Map;
import kenya.errors.KenyaPreconditionError;
import kenya.types.KBasicType;
import kenya.types.KNullType;
import kenya.types.KParamType;
import kenya.types.KType;
import kenya.types.tables.TypeTable;

public class KArrayType
extends KType {
    private KType _child;

    public KArrayType(KType child) {
        this._child = child;
        if (this._child.equals(KBasicType.getVoid())) {
            throw KenyaPreconditionError.get();
        }
        this._child = child;
    }

    public String getName() {
        return this._child.getName() + "[]";
    }

    public KType getChildType() {
        return this._child;
    }

    public String toString() {
        return this.getName();
    }

    public int getDepth() {
        int i = 1;
        KType child = this._child;
        while (child instanceof KArrayType) {
            child = ((KArrayType)child)._child;
            ++i;
        }
        return i;
    }

    public KType bind(TypeTable tt) {
        return new KArrayType(this._child.bind(tt));
    }

    public KType getBaseType() {
        KType child = this._child;
        while (child instanceof KArrayType) {
            child = ((KArrayType)child)._child;
        }
        return child;
    }

    public int compareAndBind(KType target, TypeTable tt) {
        if (target instanceof KArrayType) {
            KArrayType kat = (KArrayType)target;
            KType mc = this._child.bind(tt);
            KType tc = kat._child.bind(tt);
            if ((mc instanceof KBasicType || tc instanceof KBasicType) && mc != tc && tc != KBasicType.getString()) {
                return -1;
            }
            if (this.getChildType() instanceof KParamType && kat.getChildType() instanceof KBasicType && kat.getBaseType() != KBasicType.getString()) {
                return -2;
            }
            return this._child.compareAndBind(kat.getChildType(), tt);
        }
        if (target == KNullType.get()) {
            return 0;
        }
        return -1;
    }

    public boolean isBound(Map paramMap) {
        return this._child.isBound(paramMap);
    }

    public void populateParamMap(Map paramMap) {
        this._child.populateParamMap(paramMap);
    }
}

