/*
 * Decompiled with CFR 0.152.
 */
package kenya.types;

import java.util.HashMap;
import java.util.Map;
import kenya.types.KBoundClassType;
import kenya.types.KClassType;
import kenya.types.KType;
import kenya.types.tables.TypeTable;

public class KBasicType
extends KType {
    private static Map _preMade;
    private final String _name;
    private final KClassType _classType;

    private static void setup() {
        _preMade = new HashMap();
        _preMade.put("boolean", new KBasicType("boolean", KClassType.getBoolean()));
        _preMade.put("char", new KBasicType("char", KClassType.getCharacter()));
        _preMade.put("int", new KBasicType("int", KClassType.getInteger()));
        _preMade.put("double", new KBasicType("double", KClassType.getDouble()));
        _preMade.put("String", new KBasicType("String", null));
        _preMade.put("void", new KBasicType("void", null));
    }

    public static synchronized KBasicType getInt() {
        if (_preMade == null) {
            KBasicType.setup();
        }
        return (KBasicType)_preMade.get("int");
    }

    public static synchronized KBasicType getBoolean() {
        if (_preMade == null) {
            KBasicType.setup();
        }
        return (KBasicType)_preMade.get("boolean");
    }

    public static synchronized KBasicType getDouble() {
        if (_preMade == null) {
            KBasicType.setup();
        }
        return (KBasicType)_preMade.get("double");
    }

    public static synchronized KBasicType getChar() {
        if (_preMade == null) {
            KBasicType.setup();
        }
        return (KBasicType)_preMade.get("char");
    }

    public static synchronized KBasicType getVoid() {
        if (_preMade == null) {
            KBasicType.setup();
        }
        return (KBasicType)_preMade.get("void");
    }

    public static synchronized KBasicType getString() {
        if (_preMade == null) {
            KBasicType.setup();
        }
        return (KBasicType)_preMade.get("String");
    }

    private KBasicType(String name, KClassType classType) {
        this._name = name;
        this._classType = classType;
    }

    public String getName() {
        return this._name;
    }

    public KClassType getClassType() {
        return this._classType;
    }

    public String toString() {
        return this.getName();
    }

    public KType bind(TypeTable tt) {
        return this;
    }

    public boolean isBound(Map paramMap) {
        return true;
    }

    public int compareAndBind(KType target, TypeTable tt) {
        if (target instanceof KBoundClassType) {
            KClassType kt = ((KBoundClassType)target).getBase();
            if (this == KBasicType.getDouble() && kt == KClassType.getInteger()) {
                return 1;
            }
            if (this == KBasicType.getDouble() && kt == KClassType.getCharacter()) {
                return 2;
            }
            if (this == KBasicType.getInt() && kt == KClassType.getCharacter()) {
                return 1;
            }
            if (this == KBasicType.getDouble() && kt == KClassType.getDouble() || this == KBasicType.getInt() && kt == KClassType.getInteger() || this == KBasicType.getChar() && kt == KClassType.getCharacter() || this == KBasicType.getBoolean() && kt == KClassType.getBoolean()) {
                return 0;
            }
        }
        if (this == KBasicType.getDouble() && target == KBasicType.getInt()) {
            return 1;
        }
        if (this == KBasicType.getDouble() && target == KBasicType.getChar()) {
            return 2;
        }
        if (this == KBasicType.getInt() && target == KBasicType.getChar()) {
            return 1;
        }
        if (target == this) {
            return 0;
        }
        return -1;
    }

    public void populateParamMap(Map paramMap) {
    }
}

