/*
 * Decompiled with CFR 0.152.
 */
package kenya.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kenya.errors.KenyaInternalError;
import kenya.errors.KenyaPreconditionError;
import kenya.types.KBoundClassType;
import kenya.types.KParamType;
import kenya.types.KType;
import kenya.types.tables.SymbolTable;
import kenya.types.tables.TypeTable;

public class KClassType
extends KType {
    private String _className;
    private List _typeParams;
    private SymbolTable _children;
    private static HashMap _BasicTypes = new HashMap();

    public static synchronized KClassType getBoolean() {
        return (KClassType)_BasicTypes.get("Boolean");
    }

    public static synchronized KClassType getCharacter() {
        return (KClassType)_BasicTypes.get("Character");
    }

    public static synchronized KClassType getInteger() {
        return (KClassType)_BasicTypes.get("Integer");
    }

    public static synchronized KClassType getDouble() {
        return (KClassType)_BasicTypes.get("Double");
    }

    public KClassType(String className, List typeParams) {
        this._className = className;
        this._typeParams = typeParams == null ? Collections.unmodifiableList(new LinkedList()) : Collections.unmodifiableList(typeParams);
        this._children = null;
    }

    public void setChildren(SymbolTable children) {
        this._children = children;
    }

    public SymbolTable getChildren() {
        if (this._children == null) {
            throw new KenyaInternalError("Attempting to get children when they havn'tbeen setup yet.");
        }
        return this._children;
    }

    public Map getTypeParams() {
        Iterator it = this._typeParams.iterator();
        HashMap<String, KParamType> m = new HashMap<String, KParamType>();
        while (it.hasNext()) {
            KParamType kt = (KParamType)it.next();
            m.put(kt.toString(), kt);
        }
        return m;
    }

    public List getTypeParamList() {
        return this._typeParams;
    }

    public KType bind(TypeTable tt) {
        HashMap<KParamType, KType> m = new HashMap<KParamType, KType>();
        for (KParamType kt : this._typeParams) {
            if (tt.containsKey(kt)) {
                m.put(kt, tt.lookup(kt));
                continue;
            }
            m.put(kt, kt);
        }
        TypeTable nTT = new TypeTable(m);
        return new KBoundClassType(this, nTT);
    }

    public boolean doTypeParametersMatch(List params) {
        return params.size() == this._typeParams.size();
    }

    public TypeTable genTypeTable(List boundParams) {
        if (!this.doTypeParametersMatch(boundParams)) {
            throw new IllegalArgumentException("Type parameters do not match!");
        }
        HashMap mappings = new HashMap();
        Iterator itB = boundParams.iterator();
        Iterator itT = this._typeParams.iterator();
        while (itB.hasNext()) {
            mappings.put(itT.next(), itB.next());
        }
        return new TypeTable(mappings);
    }

    public String getName() {
        return this._className;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        if (this._typeParams.size() != 0) {
            sb.append("<");
            Iterator it = this._typeParams.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public int compareAndBind(KType target, TypeTable tt) {
        throw KenyaPreconditionError.get();
    }

    public boolean isBound(Map paramMap) {
        throw KenyaPreconditionError.get();
    }

    public void populateParamMap(Map paramMap) {
        throw KenyaPreconditionError.get();
    }

    static {
        KClassType kboolean = new KClassType("Boolean", new LinkedList());
        kboolean.setChildren(new SymbolTable());
        KClassType kchar = new KClassType("Character", new LinkedList());
        kchar.setChildren(new SymbolTable());
        KClassType kint = new KClassType("Integer", new LinkedList());
        kint.setChildren(new SymbolTable());
        KClassType kdouble = new KClassType("Double", new LinkedList());
        kdouble.setChildren(new SymbolTable());
        _BasicTypes.put("Boolean", kboolean);
        _BasicTypes.put("Character", kchar);
        _BasicTypes.put("Integer", kint);
        _BasicTypes.put("Double", kdouble);
    }
}

