/*
 * Decompiled with CFR 0.152.
 */
package kenya.types;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kenya.builtIns.IBuiltInMethod;
import kenya.errors.KenyaInternalError;
import kenya.types.KType;
import kenya.types.KVariable;
import kenya.types.tables.SymbolTable;
import minijava.node.AFuncDecDeclaration;

public class KFunction {
    private final String _name;
    private final KType _retType;
    private final Map _params;
    private final List _args;
    private final List _vars;
    private final IBuiltInMethod _bim;
    private final AFuncDecDeclaration _node;

    public KFunction(String name, Map params, KType retType, List args, List vars, IBuiltInMethod method, AFuncDecDeclaration node) {
        this._name = name;
        this._retType = retType;
        this._node = node;
        this._bim = method;
        this._params = params == null ? new HashMap() : params;
        if (args == null) {
            this._args = new LinkedList();
            this._vars = new LinkedList();
        } else {
            this._args = args;
            this._vars = vars;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof KFunction) {
            KFunction kf = (KFunction)o;
            return kf._name.equals(this._name) && ((Object)kf._args).equals(this._args);
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode() + ((Object)this._args).hashCode();
    }

    public KType getReturnType() {
        return this._retType;
    }

    public IBuiltInMethod getBuiltinMethod() {
        return this._bim;
    }

    public boolean isBuiltin() {
        return this._bim != null;
    }

    public String getName() {
        return this._name;
    }

    public List getArgs() {
        return this._args;
    }

    public List getVars() {
        return this._vars;
    }

    public SymbolTable getSymbolTable() {
        if (this._vars == null) {
            throw new KenyaInternalError("Attempting to get SymbolTable for KFunction with null arguments");
        }
        Iterator it = this._vars.iterator();
        SymbolTable st = new SymbolTable();
        while (it.hasNext()) {
            KVariable kv = (KVariable)it.next();
            st.push(kv.getName(), kv);
        }
        return st;
    }

    public Map getTypeParamMap() {
        return this._params;
    }

    public AFuncDecDeclaration getNode() {
        return this._node;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<Object> it = this._params.keySet().iterator();
        sb.append("<");
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("> ");
        sb.append(this._retType.getName());
        sb.append(" ");
        sb.append(this._name);
        sb.append("(");
        if (this._vars != null) {
            it = this._vars.iterator();
            while (it.hasNext()) {
                KVariable ki = (KVariable)it.next();
                sb.append(ki.toString());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        } else {
            it = this._args.iterator();
            while (it.hasNext()) {
                KType kt = (KType)it.next();
                sb.append(kt.getName());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        if (this._vars == null) {
            sb.append("*");
        }
        return sb.toString();
    }
}

