/*
 * Decompiled with CFR 0.152.
 */
package kenya.ui.errors;

import java.io.BufferedReader;
import java.io.IOException;
import kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import kenya.ui.IButtonManager;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class JavacErrorLabelProvider
implements ITableLabelProvider {
    private final IButtonManager ibm;
    private final String delimiter;

    public JavacErrorLabelProvider(IButtonManager ibm, String delimiter) {
        this.ibm = ibm;
        this.delimiter = delimiter;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof ISourceCodeError) {
            return this.ibm.getImage("redButton");
        }
        return this.ibm.getImage("yellowButton");
    }

    public String getColumnText(Object element, int columnIndex) {
        StringBuffer buffer = new StringBuffer();
        if (element instanceof ISourceCodeError) {
            buffer.append("Line ");
            buffer.append(((ISourceCodeError)element).getLocation().getLineNumber());
            buffer.append(": ");
            BufferedReader reader = new BufferedReader(((ISourceCodeError)element).getJavacStyleMessage());
            try {
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append(this.delimiter);
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            buffer.delete(buffer.length() - this.delimiter.length(), buffer.length());
        } else if (element instanceof ISourceCodeInformation) {
            buffer.append("Line ");
            buffer.append(((ISourceCodeInformation)element).getLocation().getLineNumber());
            buffer.append(": ");
            BufferedReader reader = new BufferedReader(((ISourceCodeInformation)element).getHumanStyleMessage());
            try {
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append(this.delimiter);
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            buffer.delete(buffer.length() - this.delimiter.length(), buffer.length());
        }
        return buffer.toString();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

