/*
 * Decompiled with CFR 0.152.
 */
package kenya.ui.errors;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import kenya.sourceCodeInformation.interfaces.ISourceCodeError;
import kenya.sourceCodeInformation.interfaces.ISourceCodeInformation;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import mediator.ICheckedCode;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class KenyaErrorContentProvider
implements IStructuredContentProvider {
    private static final Comparator itemComparator = new Comparator(){

        public int compare(ISourceCodeError arg0, ISourceCodeError arg1) {
            ISourceCodeLocation loc0 = arg0.getLocation();
            ISourceCodeLocation loc1 = arg1.getLocation();
            return this.compare(loc0, loc1);
        }

        public int compare(ISourceCodeInformation arg0, ISourceCodeInformation arg1) {
            ISourceCodeLocation loc0 = arg0.getLocation();
            ISourceCodeLocation loc1 = arg1.getLocation();
            return this.compare(loc0, loc1);
        }

        public int compare(ISourceCodeError arg0, Object arg1) {
            return -1;
        }

        public int compare(ISourceCodeInformation arg0, Object arg1) {
            return 1;
        }

        public int compare(ISourceCodeLocation loc0, ISourceCodeLocation loc1) {
            if (loc0.getLineNumber() == loc1.getLineNumber()) {
                if (loc0.getColumnNumber() == loc1.getColumnNumber()) {
                    if (loc0.getTokenLength() == loc1.getTokenLength()) {
                        return 0;
                    }
                    return loc1.getTokenLength() - loc0.getTokenLength();
                }
                return loc0.getColumnNumber() - loc1.getColumnNumber();
            }
            return loc0.getLineNumber() - loc1.getLineNumber();
        }

        public int compare(Object arg0, Object arg1) {
            return 0;
        }
    };
    private final SortedSet errors = new TreeSet(itemComparator);

    public synchronized Object[] getElements(Object inputElement) {
        this.errors.clear();
        ICheckedCode checker = (ICheckedCode)inputElement;
        if (checker.isErroredCode()) {
            this.errors.addAll(checker.getErrors());
        }
        this.errors.addAll(checker.getInfos());
        return this.errors.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public synchronized int getIndex(ISourceCodeInformation error) {
        if (this.errors.contains(error)) {
            int count = 0;
            for (Object item : this.errors) {
                if (error.equals(item)) {
                    return count;
                }
                ++count;
            }
            return -1;
        }
        return -1;
    }
}

