/*
 * Decompiled with CFR 0.152.
 */
package mediator;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kenya.errors.KenyaInternalError;
import kenya.passes.Translator;
import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.IVariable;
import kenya.types.KFunction;
import mediator.ICheckedCode;
import mediator.IJavaCode;
import mediator.stackMachine.IStackMachineInformationProvider;
import mediator.stackMachine.StackMachineInformationManager;
import mediator.util.InformationHolder;
import mediator.util.JavaCode;
import mediator.util.ValidMainChecker;
import minijava.node.AFuncDecDeclaration;

class ValidCode
implements ICheckedCode {
    private final List _infos;
    private final InformationHolder _ih;
    private final ValidMainChecker _vmc;
    private final Map _functionMap;
    private final Map _typeMap;

    public ValidCode(List infos, InformationHolder ih, ValidMainChecker vmc, Map functionMap, Map typeMap) {
        if (infos == null) {
            throw new NullPointerException("Infos can't be null");
        }
        if (ih == null) {
            throw new NullPointerException("Information Holder can't be null");
        }
        this._infos = Collections.unmodifiableList(infos);
        this._ih = ih;
        this._vmc = vmc;
        this._functionMap = functionMap;
        this._typeMap = typeMap;
    }

    public boolean isErroredCode() {
        return false;
    }

    public List getInfos() {
        return this._infos;
    }

    public List getErrors() {
        throw new IllegalStateException("Valid Kenya has no errors.");
    }

    public IJavaCode translate() {
        int i;
        boolean require15 = false;
        TreeSet allImports = new TreeSet();
        Iterator<Object> it = this._functionMap.keySet().iterator();
        while (it.hasNext()) {
            KFunction kf = (KFunction)this._functionMap.get(it.next());
            if (kf.isBuiltin()) {
                allImports.addAll(kf.getBuiltinMethod().getImports());
                continue;
            }
            if (kf.getTypeParamMap().entrySet().size() == 0) continue;
            require15 = true;
        }
        StringBuffer sb = new StringBuffer();
        it = allImports.iterator();
        while (it.hasNext()) {
            sb.append("import ");
            sb.append(it.next());
            sb.append(";");
            sb.append(IJavaCode.NEWLINE);
        }
        String imports = sb.toString();
        HashSet allBuiltinTypes = new HashSet();
        Iterator it2 = this._functionMap.keySet().iterator();
        while (it2.hasNext()) {
            KFunction kf = (KFunction)this._functionMap.get(it2.next());
            if (!kf.isBuiltin()) continue;
            allBuiltinTypes.addAll(kf.getBuiltinMethod().getReservedClasses());
        }
        AFuncDecDeclaration node = this._vmc.getMainWithStringArgs() != null ? this._vmc.getMainWithStringArgs().getDeclarationNode() : null;
        Translator translator = new Translator(this._functionMap, node, this._typeMap, true);
        translator.reset(8);
        this._ih.getRootNode().apply(translator);
        String constants = translator.getLastCode();
        translator.reset(1);
        this._ih.getRootNode().apply(translator);
        String functions = translator.getLastCode();
        if (!this._vmc.haveMainWithStringArgs()) {
            if (this._vmc.haveMainNoArgs()) {
                functions = IJavaCode.NEWLINE + "    " + "public static void main(String[] args) {" + IJavaCode.NEWLINE + "    " + "    " + "main();" + IJavaCode.NEWLINE + "    " + "}" + IJavaCode.NEWLINE + functions;
            } else {
                throw new KenyaInternalError("Failed Precondition");
            }
        }
        translator.reset(6);
        this._ih.getRootNode().apply(translator);
        String classesAndEnums = translator.getLastCode();
        HashSet typeNames = new HashSet();
        typeNames.addAll(allBuiltinTypes);
        for (i = 0; i < this._ih.getClasses().length; ++i) {
            typeNames.add(this._ih.getClasses()[i].getName());
            require15 |= this._ih.getClasses()[i].getTemplateParams().length != 0;
        }
        for (i = 0; i < this._ih.getEnums().length; ++i) {
            typeNames.add(this._ih.getEnums()[i].getName());
            require15 = true;
        }
        if (!require15) {
            require15 = this._ih.areClassBasicTypesUsed();
        }
        return new JavaCode(imports, constants, functions, classesAndEnums, typeNames, require15);
    }

    public IStackMachineInformationProvider getBaseStackMachine() {
        StackMachineInformationManager smi = new StackMachineInformationManager(this._ih);
        return smi.build(this._vmc);
    }

    public IClass[] getClasses() {
        return this._ih.getClasses();
    }

    public IVariable[] getConstants() {
        return this._ih.getConstants();
    }

    public IClass[] getEnums() {
        return this._ih.getEnums();
    }

    public IFunction[] getFunctions() {
        return this._ih.getFunctions();
    }
}

