/*
 * Decompiled with CFR 0.152.
 */
package mediator.util;

import kenya.sourceCodeInformation.interfaces.IClass;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.interfaces.IVariable;
import minijava.node.AFuncDecDeclaration;

public class AFunctionInstance
implements IFunction {
    private final IClass[] _typeParams;
    private final String _name;
    private final IClass _returnType;
    private final IVariable[] _arguments;
    private final ISourceCodeLocation _position;
    private final AFuncDecDeclaration _node;

    public AFunctionInstance(IClass[] typeParams, String name, IClass returnType, IVariable[] arguments, ISourceCodeLocation position, AFuncDecDeclaration node) {
        this._typeParams = typeParams;
        this._name = name;
        this._returnType = returnType;
        this._arguments = arguments;
        this._position = position;
        this._node = node;
    }

    public IFunction normalise() {
        int i;
        IClass[] typeParams = new IClass[this._typeParams.length];
        IClass returnType = this._returnType.normalise();
        IVariable[] arguments = new IVariable[this._arguments.length];
        for (i = 0; i < typeParams.length; ++i) {
            typeParams[i] = this._typeParams[i].normalise();
        }
        for (i = 0; i < arguments.length; ++i) {
            arguments[i] = this._arguments[i].normalise();
        }
        return new AFunctionInstance(typeParams, this._name, returnType, arguments, this._position, this._node);
    }

    public IClass[] getTypeParams() {
        return this._typeParams;
    }

    public String getName() {
        return this._name;
    }

    public IClass getReturnType() {
        return this._returnType;
    }

    public IVariable[] getArguments() {
        return this._arguments;
    }

    public ISourceCodeLocation getPosition() {
        return this._position;
    }

    public AFuncDecDeclaration getDeclarationNode() {
        return this._node;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this._typeParams.length > 0) {
            sb.append("<");
            for (i = 0; i < this._typeParams.length; ++i) {
                sb.append(this._typeParams[i].toString());
                if (i >= this._typeParams.length - 1) continue;
                sb.append(",");
            }
            sb.append(" ");
        }
        sb.append(this._returnType);
        sb.append(" ");
        sb.append(this._name);
        sb.append("(");
        for (i = 0; i < this._arguments.length; ++i) {
            sb.append(this._arguments[i].toString());
            if (i >= this._arguments.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

