/*
 * Decompiled with CFR 0.152.
 */
package mediator.util;

import kenya.sourceCodeInformation.interfaces.IFunction;
import mediator.util.InformationHolder;

public class ValidMainChecker {
    private final boolean _mainNoArgs;
    private final boolean _mainWithStringArgs;
    private final IFunction _noArgsMain;
    private final IFunction _withStringArgsMain;

    public ValidMainChecker(InformationHolder ih) {
        boolean mainNoArgs = false;
        boolean mainWithStringArgs = false;
        IFunction noArgsMains = null;
        IFunction withStringArgsMain = null;
        IFunction[] funcs = ih.getFunctions();
        for (int i = 0; i < funcs.length; ++i) {
            String name = funcs[i].getName();
            if (!name.equals("main") || funcs[i].getTypeParams().length != 0) continue;
            if (funcs[i].getArguments().length == 0) {
                if (!funcs[i].getReturnType().getName().equals("void")) continue;
                mainNoArgs = true;
                noArgsMains = funcs[i];
            }
            if (funcs[i].getArguments().length == 1 && funcs[i].getArguments()[0].getType().getName().equals("String[]")) {
                if (!funcs[i].getReturnType().getName().equals("void")) {
                    this._mainNoArgs = false;
                    this._mainWithStringArgs = false;
                    this._noArgsMain = null;
                    this._withStringArgsMain = null;
                    return;
                }
                mainWithStringArgs = true;
                withStringArgsMain = funcs[i];
            }
            if (mainWithStringArgs && mainNoArgs) break;
        }
        this._mainNoArgs = mainNoArgs;
        this._mainWithStringArgs = mainWithStringArgs;
        this._noArgsMain = noArgsMains;
        this._withStringArgsMain = withStringArgsMain;
    }

    public boolean haveMainWithStringArgs() {
        return this._mainWithStringArgs;
    }

    public boolean haveMainNoArgs() {
        return this._mainNoArgs;
    }

    public IFunction getMainWithStringArgs() {
        return this._withStringArgsMain;
    }

    public IFunction getMainWithNoArgs() {
        return this._noArgsMain;
    }
}

