/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.types;

import org.wellquite.kenya.stackMachine.types.IntType;
import org.wellquite.kenya.stackMachine.types.interfaces.ICharType;
import org.wellquite.kenya.stackMachine.types.interfaces.INumericType;

public class DoubleType
implements INumericType {
    private double value = 0.0;
    private boolean assigned = false;

    public DoubleType() {
    }

    public DoubleType(double value) {
        this.value = value;
        this.assigned = true;
    }

    public synchronized Number getValue() {
        return new Double(this.value);
    }

    public synchronized void setValue(Number value) {
        if (this.assigned) {
            DoubleType.modificationError(this);
        } else {
            this.value = value.intValue();
            this.assigned = true;
        }
    }

    public synchronized String toString() {
        return "DoubleType: " + this.value;
    }

    public synchronized boolean valueSet() {
        return this.assigned;
    }

    private static void modificationError(DoubleType variable) {
        throw new RuntimeException("Attempt made to modify String variable: " + variable);
    }

    public String valueToString() {
        return "" + this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof INumericType) {
            if (obj instanceof IntType) {
                return (double)((INumericType)obj).getValue().intValue() == this.getValue().doubleValue();
            }
            return ((INumericType)obj).getValue().doubleValue() == this.getValue().doubleValue();
        }
        if (obj instanceof ICharType) {
            return (double)((ICharType)obj).getValue().charValue() == this.getValue().doubleValue();
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public String getTypeName() {
        return "double";
    }

    public Object clone() throws CloneNotSupportedException {
        DoubleType t = (DoubleType)super.clone();
        return t;
    }
}

