/*
 * Decompiled with CFR 0.152.
 */
package org.wellquite.kenya.stackMachine.types;

import java.util.HashMap;
import java.util.Map;
import org.wellquite.kenya.stackMachine.types.BooleanType;
import org.wellquite.kenya.stackMachine.types.CharType;
import org.wellquite.kenya.stackMachine.types.DoubleType;
import org.wellquite.kenya.stackMachine.types.IntType;
import org.wellquite.kenya.stackMachine.types.interfaces.IBooleanType;
import org.wellquite.kenya.stackMachine.types.interfaces.ICharType;

public class PrimitiveTypeFactory {
    private static final IBooleanType trueBool = new BooleanType(true);
    private static final IBooleanType falseBool = new BooleanType(false);
    private static final Map intMap = new HashMap();
    private static final Map doubleMap = new HashMap();
    private static final Map charMap = new HashMap();

    public static synchronized IntType createPrimitiveType(int value) {
        Integer key = new Integer(value);
        if (intMap.containsKey(key)) {
            return (IntType)intMap.get(key);
        }
        IntType it = new IntType(value);
        intMap.put(key, it);
        return it;
    }

    public static synchronized DoubleType createPrimitiveType(double value) {
        Double key = new Double(value);
        if (doubleMap.containsKey(key)) {
            return (DoubleType)doubleMap.get(key);
        }
        DoubleType dt = new DoubleType(value);
        doubleMap.put(key, dt);
        return dt;
    }

    public static IBooleanType createPrimitiveType(boolean value) {
        if (value) {
            return trueBool;
        }
        return falseBool;
    }

    public static synchronized ICharType createPrimitiveType(char value) {
        Character key = new Character(value);
        if (charMap.containsKey(key)) {
            return (ICharType)charMap.get(key);
        }
        CharType ct = new CharType(value);
        charMap.put(key, ct);
        return ct;
    }

    private PrimitiveTypeFactory() {
    }
}

